/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.jei.machine;

import java.util.Collections;
import java.util.List;
import mekanism.api.math.MathUtils;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.recipe_viewer.jei.BaseRecipeCategory;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mekanism.client.recipe_viewer.recipe.BoilerRecipeViewerRecipe;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.MekanismLang;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.TextUtils;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoilerRecipeCategory
extends BaseRecipeCategory<BoilerRecipeViewerRecipe> {
    private final GuiGauge<?> superHeatedCoolantTank;
    private final GuiGauge<?> waterTank;
    private final GuiGauge<?> steamTank;
    private final GuiGauge<?> cooledCoolantTank;
    @Nullable
    private BoilerRecipeViewerRecipe recipe;

    public BoilerRecipeCategory(IGuiHelper helper, IRecipeViewerRecipeType<BoilerRecipeViewerRecipe> recipeType) {
        super(helper, recipeType);
        this.addElement(new GuiInnerScreen((IGuiWrapper)this, 48, 23, 96, 40, () -> {
            int boilRate;
            double temperature;
            if (this.recipe == null) {
                temperature = 300.0;
                boilRate = 0;
            } else {
                temperature = this.recipe.temperature();
                boilRate = MathUtils.clampToInt(this.recipe.steam().getAmount());
            }
            return List.of(MekanismLang.TEMPERATURE.translate(MekanismUtils.getTemperatureDisplay(temperature, UnitDisplayUtils.TemperatureUnit.KELVIN, true)), MekanismLang.BOIL_RATE.translate(TextUtils.format(boilRate)));
        }));
        this.superHeatedCoolantTank = this.addElement(GuiGasGauge.getDummy(GaugeType.STANDARD, this, 6, 13).setLabel((Component)MekanismLang.BOILER_HEATED_COOLANT_TANK.translateColored(EnumColor.ORANGE)));
        this.waterTank = this.addElement(GuiFluidGauge.getDummy(GaugeType.STANDARD, this, 26, 13).setLabel((Component)MekanismLang.BOILER_WATER_TANK.translateColored(EnumColor.INDIGO)));
        this.steamTank = this.addElement(GuiGasGauge.getDummy(GaugeType.STANDARD, this, 148, 13).setLabel((Component)MekanismLang.BOILER_STEAM_TANK.translateColored(EnumColor.GRAY)));
        this.cooledCoolantTank = this.addElement(GuiGasGauge.getDummy(GaugeType.STANDARD, this, 168, 13).setLabel((Component)MekanismLang.BOILER_COOLANT_TANK.translateColored(EnumColor.AQUA)));
    }

    @Override
    public void draw(BoilerRecipeViewerRecipe recipe, IRecipeSlotsView recipeSlotView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.recipe = recipe;
        super.draw(recipe, recipeSlotView, guiGraphics, mouseX, mouseY);
        this.recipe = null;
    }

    @Override
    protected void renderElements(BoilerRecipeViewerRecipe recipe, IRecipeSlotsView recipeSlotView, GuiGraphics guiGraphics, int x, int y) {
        super.renderElements(recipe, recipeSlotView, guiGraphics, x, y);
        if (recipe.superHeatedCoolant() == null) {
            this.superHeatedCoolantTank.drawBarOverlay(guiGraphics);
            this.cooledCoolantTank.drawBarOverlay(guiGraphics);
        }
    }

    public void setRecipe(@NotNull IRecipeLayoutBuilder builder, BoilerRecipeViewerRecipe recipe, @NotNull IFocusGroup focusGroup) {
        this.initFluid(builder, RecipeIngredientRole.INPUT, this.waterTank, recipe.water().getRepresentations());
        if (recipe.superHeatedCoolant() == null) {
            this.initChemical(builder, MekanismJEI.TYPE_GAS, RecipeIngredientRole.OUTPUT, this.steamTank, Collections.singletonList(recipe.steam()));
        } else {
            this.initChemical(builder, MekanismJEI.TYPE_GAS, RecipeIngredientRole.INPUT, this.superHeatedCoolantTank, recipe.superHeatedCoolant().getRepresentations());
            this.initChemical(builder, MekanismJEI.TYPE_GAS, RecipeIngredientRole.OUTPUT, this.steamTank, Collections.singletonList(recipe.steam()));
            this.initChemical(builder, MekanismJEI.TYPE_GAS, RecipeIngredientRole.OUTPUT, this.cooledCoolantTank, Collections.singletonList(recipe.cooledCoolant()));
        }
    }
}

