/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.client.gui.element.GuiDownArrow;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.recipe_viewer.emi.MekanismEmiRecipeCategory;
import mekanism.client.recipe_viewer.emi.recipe.MekanismEmiRecipe;
import mekanism.common.inventory.container.slot.SlotOverlay;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public class RotaryEmiRecipe
extends MekanismEmiRecipe<RotaryRecipe> {
    private final RecipeHolder<RotaryRecipe> recipeHolder;
    private final boolean condensentrating;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RotaryEmiRecipe(MekanismEmiRecipeCategory category, ResourceLocation id, RecipeHolder<RotaryRecipe> recipeHolder, boolean condensentrating) {
        super(category, id, (RotaryRecipe)recipeHolder.value());
        this.recipeHolder = recipeHolder;
        this.condensentrating = condensentrating;
        if (condensentrating) {
            if (!((RotaryRecipe)this.recipe).hasGasToFluid()) throw new IllegalArgumentException("Condensentrating recipes require a gas to fluid component");
            this.addInputDefinition(((RotaryRecipe)this.recipe).getGasInput());
            this.addFluidOutputDefinition(((RotaryRecipe)this.recipe).getFluidOutputDefinition());
            return;
        } else {
            if (!((RotaryRecipe)this.recipe).hasFluidToGas()) throw new IllegalArgumentException("Decondensentrating recipes require a fluid to gas component");
            this.addInputDefinition(((RotaryRecipe)this.recipe).getFluidInput());
            this.addChemicalOutputDefinition(((RotaryRecipe)this.recipe).getGasOutputDefinition());
        }
    }

    @Override
    @Nullable
    public RecipeHolder<RotaryRecipe> getBackingRecipe() {
        return this.recipeHolder;
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        this.addElement(widgetHolder, new GuiDownArrow(this, 159, 44));
        SlotWidget leftWidget = this.initTank(widgetHolder, GuiGasGauge.getDummy(GaugeType.STANDARD, this, 25, 13), this.condensentrating ? this.input(0) : this.output(0));
        SlotWidget rightWidget = this.initTank(widgetHolder, GuiFluidGauge.getDummy(GaugeType.STANDARD, this, 133, 13), this.condensentrating ? this.output(0) : this.input(0));
        if (this.condensentrating) {
            rightWidget.recipeContext((EmiRecipe)this);
        } else {
            leftWidget.recipeContext((EmiRecipe)this);
        }
        this.addSlot(widgetHolder, SlotType.INPUT, 5, 25).with(SlotOverlay.PLUS);
        this.addSlot(widgetHolder, SlotType.OUTPUT, 5, 56).with(SlotOverlay.MINUS);
        this.addSlot(widgetHolder, SlotType.INPUT, 155, 25);
        this.addSlot(widgetHolder, SlotType.OUTPUT, 155, 56);
        this.addConstantProgress(widgetHolder, this.condensentrating ? ProgressType.LARGE_RIGHT : ProgressType.LARGE_LEFT, 64, 39);
    }
}

