/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.recipes.ItemStackToFluidOptionalItemRecipe;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.recipe_viewer.emi.MekanismEmiRecipeCategory;
import mekanism.client.recipe_viewer.emi.recipe.MekanismEmiRecipe;
import mekanism.common.tile.component.config.DataType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class ItemStackToFluidOptionalItemEmiRecipe
extends MekanismEmiRecipe<ItemStackToFluidOptionalItemRecipe> {
    private final int processTime;

    public ItemStackToFluidOptionalItemEmiRecipe(MekanismEmiRecipeCategory category, ResourceLocation id, ItemStackToFluidOptionalItemRecipe recipe, int processTime) {
        super(category, id, recipe);
        this.processTime = processTime;
        this.addInputDefinition(recipe.getInput());
        List<ItemStackToFluidOptionalItemRecipe.FluidOptionalItemOutput> outputDefinition = recipe.getOutputDefinition();
        ArrayList<FluidStack> fluidOutputs = new ArrayList<FluidStack>(outputDefinition.size());
        ArrayList<ItemStack> itemOutputs = new ArrayList<ItemStack>();
        for (ItemStackToFluidOptionalItemRecipe.FluidOptionalItemOutput output : outputDefinition) {
            fluidOutputs.add(output.fluid());
            itemOutputs.add(output.optionalItem());
        }
        this.addFluidOutputDefinition(fluidOutputs);
        if (itemOutputs.stream().allMatch(ConstantPredicates.ITEM_EMPTY)) {
            this.addOutputDefinition(Collections.emptyList());
        } else {
            this.addItemOutputDefinition(itemOutputs);
        }
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        this.initTank(widgetHolder, GuiFluidGauge.getDummy(GaugeType.STANDARD.with(DataType.OUTPUT), this, 131, 13), this.output(0)).recipeContext((EmiRecipe)this);
        this.addSlot(widgetHolder, SlotType.INPUT, 26, 36, this.input(0));
        this.addSlot(widgetHolder, SlotType.INPUT, 110, 36, this.output(1));
        if (this.processTime == 0) {
            this.addConstantProgress(widgetHolder, ProgressType.LARGE_RIGHT, 54, 40);
        } else {
            this.addSimpleProgress(widgetHolder, ProgressType.LARGE_RIGHT, 54, 40, this.processTime);
        }
    }
}

