/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer.emi;

import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.serializer.EmiStackSerializer;
import java.util.Optional;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.client.recipe_viewer.emi.ChemicalEmiStack;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.resources.ResourceLocation;

@NothingNullByDefault
public class ChemicalEmiIngredientSerializer<CHEMICAL extends Chemical<CHEMICAL>, EMI_STACK extends ChemicalEmiStack<CHEMICAL>>
implements EmiStackSerializer<EMI_STACK> {
    private final EmiStackCreator<CHEMICAL, EMI_STACK> stackCreator;
    private final Registry<CHEMICAL> registry;
    private final String type;

    ChemicalEmiIngredientSerializer(Registry<CHEMICAL> registry, EmiStackCreator<CHEMICAL, EMI_STACK> stackCreator) {
        this.registry = registry;
        this.stackCreator = stackCreator;
        this.type = registry.key().location().toString().replace(':', '_');
    }

    public EmiStack create(ResourceLocation id, DataComponentPatch ignored, long amount) {
        Optional<Chemical> chemical = this.registry.getOptional(id).filter(c -> !c.isEmptyType());
        if (chemical.isPresent()) {
            return this.stackCreator.create(chemical.get(), amount);
        }
        return EmiStack.EMPTY;
    }

    public String getType() {
        return this.type;
    }

    void addEmiStacks(EmiRegistry emiRegistry) {
        for (Chemical chemical : this.registry) {
            if (chemical.isEmptyType()) continue;
            emiRegistry.addEmiStack(this.stackCreator.create(chemical, 1L));
        }
    }

    @FunctionalInterface
    public static interface EmiStackCreator<CHEMICAL extends Chemical<CHEMICAL>, EMI_STACK extends ChemicalEmiStack<CHEMICAL>> {
        public EMI_STACK create(CHEMICAL var1, long var2);
    }
}

