/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mekanism.api.MekanismAPITags;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.ItemStackToFluidOptionalItemRecipe;
import mekanism.api.recipes.chemical.ItemStackToChemicalRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.SlurryStackIngredient;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.progress.IProgressInfoHandler;
import mekanism.common.MekanismLang;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.tier.ChemicalTankTier;
import mekanism.common.tile.machine.TileEntityNutritionalLiquifier;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.RegistryUtils;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.TimeUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;

public class RecipeViewerUtils {
    public static final IProgressInfoHandler CONSTANT_PROGRESS = () -> 1.0;
    public static final GuiBar.IBarInfoHandler FULL_BAR = () -> 1.0;

    private RecipeViewerUtils() {
    }

    public static IProgressInfoHandler progressHandler(int processTime) {
        int time = 50 * processTime;
        return () -> {
            double subTime = System.currentTimeMillis() % (long)time;
            return subTime / (double)time;
        };
    }

    public static GuiBar.IBarInfoHandler barProgressHandler(int processTime) {
        MutableComponent tooltip = MekanismLang.TICKS_REQUIRED.translate(processTime);
        int time = 50 * processTime;
        return new GuiBar.IBarInfoHandler(){
            final /* synthetic */ Component val$tooltip;
            final /* synthetic */ int val$time;
            {
                this.val$tooltip = component;
                this.val$time = n;
            }

            @Override
            public Component getTooltip() {
                return this.val$tooltip;
            }

            @Override
            public double getLevel() {
                double subTime = System.currentTimeMillis() % (long)this.val$time;
                return subTime / (double)this.val$time;
            }
        };
    }

    public static ResourceLocation synthetic(ResourceLocation id, String prefix, String namespace) {
        return RecipeViewerUtils.synthetic(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)id.toString().replace(':', '_')), prefix);
    }

    public static ResourceLocation synthetic(ResourceLocation id, String prefix) {
        return id.withPrefix("/" + prefix + "/");
    }

    public static <T> T getCurrent(List<T> elements) {
        return elements.get(RecipeViewerUtils.getIndex(elements));
    }

    public static int getIndex(List<?> elements) {
        return (int)(System.currentTimeMillis() / TimeUtil.MILLISECONDS_PER_SECOND % (long)elements.size());
    }

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> List<ItemStack> getStacksFor(ChemicalStackIngredient<CHEMICAL, STACK, ?> ingredient, boolean displayConversions) {
        Set chemicals = ingredient.getRepresentations().stream().map(ChemicalStack::getChemical).collect(Collectors.toSet());
        if (!displayConversions) {
            return RecipeViewerUtils.getStacksFor(chemicals, null);
        }
        ChemicalType chemicalType = ChemicalType.getTypeFor(ingredient);
        return RecipeViewerUtils.getStacksFor(chemicals, switch (chemicalType) {
            case ChemicalType.GAS -> MekanismRecipeType.GAS_CONVERSION;
            case ChemicalType.INFUSION -> MekanismRecipeType.INFUSION_CONVERSION;
            default -> null;
        });
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>> List<ItemStack> getStacksFor(Set<CHEMICAL> supportedTypes, @Nullable IMekanismRecipeTypeProvider<?, ? extends ItemStackToChemicalRecipe<CHEMICAL, ?>, ?> recipeType) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (Chemical chemical : supportedTypes) {
            stacks.add(ChemicalUtil.getFullChemicalTank(ChemicalTankTier.BASIC, chemical));
        }
        if (recipeType != null) {
            block1: for (RecipeHolder recipeHolder : recipeType.getRecipes(null)) {
                ItemStackToChemicalRecipe recipe = (ItemStackToChemicalRecipe)recipeHolder.value();
                for (ChemicalStack output : recipe.getOutputDefinition()) {
                    if (!supportedTypes.contains(output.getChemical())) continue;
                    stacks.addAll(recipe.getInput().getRepresentations());
                    continue block1;
                }
            }
        }
        return stacks;
    }

    public static Map<ResourceLocation, ItemStackToFluidOptionalItemRecipe> getLiquificationRecipes() {
        HashMap<ResourceLocation, ItemStackToFluidOptionalItemRecipe> liquification = new HashMap<ResourceLocation, ItemStackToFluidOptionalItemRecipe>();
        for (Item item : BuiltInRegistries.ITEM) {
            ItemStackToFluidOptionalItemRecipe recipe = TileEntityNutritionalLiquifier.getRecipe(item.getDefaultInstance());
            if (recipe == null) continue;
            liquification.put(RecipeViewerUtils.synthetic(RegistryUtils.getName(item), "liquification", "mekanism"), recipe);
        }
        return liquification;
    }

    public static List<ItemStack> getDisplayItems(SlurryStackIngredient ingredient) {
        LinkedHashSet tags = new LinkedHashSet();
        for (SlurryStack slurryStack : ingredient.getRepresentations()) {
            TagKey<Item> oreTag;
            Slurry slurry = (Slurry)slurryStack.getChemical();
            if (slurry.is(MekanismAPITags.Slurries.DIRTY) || (oreTag = slurry.getOreTag()) == null) continue;
            BuiltInRegistries.ITEM.getTag(oreTag).ifPresent(tags::add);
        }
        if (tags.size() == 1) {
            return ((HolderSet.Named)tags.getFirst()).stream().map(ItemStack::new).toList();
        }
        return Collections.emptyList();
    }
}

