/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.recipe_viewer;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.client.recipe_viewer.GuiElementHandler;
import mekanism.client.recipe_viewer.interfaces.IRecipeViewerGhostTarget;
import mekanism.common.lib.collection.LRU;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.Rect2i;

public class GhostIngredientHandler {
    public static <INGREDIENT, TARGET> List<TARGET> getTargetsTyped(GuiMekanism<?> gui, INGREDIENT ingredient, BiFunction<IRecipeViewerGhostTarget.IGhostIngredientConsumer, INGREDIENT, Object> supportedIngredient, TargetCreator<TARGET> targetCreator) {
        boolean hasTargets = false;
        int depth = 0;
        Int2ObjectLinkedOpenHashMap depthBasedTargets = new Int2ObjectLinkedOpenHashMap();
        Int2ObjectOpenHashMap layerIntersections = new Int2ObjectOpenHashMap();
        List<TargetInfo<TARGET>> ghostTargets = GhostIngredientHandler.getTargets(gui.children(), ingredient, supportedIngredient, targetCreator);
        if (!ghostTargets.isEmpty()) {
            depthBasedTargets.put(depth, ghostTargets);
            hasTargets = true;
        }
        LRU.LRUIterator iter = gui.getWindowsDescendingIterator();
        while (iter.hasNext()) {
            GuiWindow window = (GuiWindow)iter.next();
            ++depth;
            if (hasTargets) {
                ArrayList<Rect2i> areas = new ArrayList<Rect2i>();
                areas.add(new Rect2i(window.getX(), window.getY(), window.getWidth(), window.getHeight()));
                areas.addAll(GuiElementHandler.getAreasFor(window.getX(), window.getY(), window.getWidth(), window.getHeight(), window.children()));
                layerIntersections.put(depth, areas);
            }
            if ((ghostTargets = GhostIngredientHandler.getTargets(window.children(), ingredient, supportedIngredient, targetCreator)).isEmpty()) continue;
            depthBasedTargets.put(depth, ghostTargets);
            hasTargets = true;
        }
        if (!hasTargets) {
            return Collections.emptyList();
        }
        ArrayList targets = new ArrayList();
        ArrayList<Rect2i> coveredArea = new ArrayList<Rect2i>();
        Int2ObjectSortedMap.FastSortedEntrySet depthEntries = depthBasedTargets.int2ObjectEntrySet();
        ObjectBidirectionalIterator iter2 = depthEntries.fastIterator((Int2ObjectMap.Entry)depthEntries.last());
        while (iter2.hasPrevious()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iter2.previous();
            int targetDepth = entry.getIntKey();
            while (depth > targetDepth) {
                coveredArea.addAll((Collection)layerIntersections.get(depth));
                --depth;
            }
            for (TargetInfo ghostTarget : (List)entry.getValue()) {
                targets.addAll(ghostTarget.convertToTargets(coveredArea));
            }
        }
        return targets;
    }

    private static <INGREDIENT, TARGET> List<TargetInfo<TARGET>> getTargets(List<? extends GuiEventListener> children, INGREDIENT ingredient, BiFunction<IRecipeViewerGhostTarget.IGhostIngredientConsumer, INGREDIENT, Object> supportedIngredient, TargetCreator<TARGET> targetCreator) {
        ArrayList<TargetInfo<TARGET>> ghostTargets = new ArrayList<TargetInfo<TARGET>>();
        for (GuiEventListener guiEventListener : children) {
            Object supported;
            IRecipeViewerGhostTarget ghostTarget;
            IRecipeViewerGhostTarget.IGhostIngredientConsumer ghostHandler;
            if (!(guiEventListener instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)guiEventListener;
            if (!widget.visible) continue;
            if (widget instanceof ContainerEventHandler) {
                ContainerEventHandler eventHandler = (ContainerEventHandler)widget;
                ghostTargets.addAll(GhostIngredientHandler.getTargets(eventHandler.children(), ingredient, supportedIngredient, targetCreator));
            }
            if (!(widget instanceof IRecipeViewerGhostTarget) || (ghostHandler = (ghostTarget = (IRecipeViewerGhostTarget)widget).getGhostHandler()) == null || (supported = supportedIngredient.apply(ghostHandler, ingredient)) == null) continue;
            ghostTargets.add(new TargetInfo<TARGET>(ghostTarget, ghostHandler, widget.getX(), widget.getY(), widget.getWidth(), widget.getHeight(), supported, targetCreator));
        }
        return ghostTargets;
    }

    private static void addVisibleAreas(List<Rect2i> visible, Rect2i area, List<Rect2i> coveredArea) {
        boolean intersected = false;
        int x = area.getX();
        int x2 = x + area.getWidth();
        int y = area.getY();
        int y2 = y + area.getHeight();
        int size = coveredArea.size();
        for (int i = 0; i < size; ++i) {
            Rect2i covered = coveredArea.get(i);
            int cx = covered.getX();
            int cx2 = cx + covered.getWidth();
            int cy = covered.getY();
            int cy2 = cy + covered.getHeight();
            if (x >= cx2 || x2 <= cx || y >= cy2 || y2 <= cy) continue;
            intersected = true;
            if (x >= cx && y >= cy && x2 <= cx2 && y2 <= cy2) break;
            List<Rect2i> uncoveredArea = GhostIngredientHandler.getVisibleArea(area, covered);
            if (i + 1 == size) {
                visible.addAll(uncoveredArea);
                break;
            }
            List<Rect2i> coveredAreas = coveredArea.subList(i + 1, size);
            for (Rect2i visibleArea : uncoveredArea) {
                GhostIngredientHandler.addVisibleAreas(visible, visibleArea, coveredAreas);
            }
            break;
        }
        if (!intersected) {
            visible.add(area);
        }
    }

    private static List<Rect2i> getVisibleArea(Rect2i area, Rect2i coveredArea) {
        int x = area.getX();
        int x2 = x + area.getWidth();
        int y = area.getY();
        int y2 = y + area.getHeight();
        int cx = coveredArea.getX();
        int cx2 = cx + coveredArea.getWidth();
        int cy = coveredArea.getY();
        int cy2 = cy + coveredArea.getHeight();
        boolean intersectsTop = y >= cy && y <= cy2;
        boolean intersectsLeft = x >= cx && x <= cx2;
        boolean intersectsBottom = y2 >= cy && y2 <= cy2;
        boolean intersectsRight = x2 >= cx && x2 <= cx2;
        ArrayList<Rect2i> areas = new ArrayList<Rect2i>();
        if (intersectsTop && intersectsBottom) {
            if (intersectsLeft) {
                areas.add(new Rect2i(cx2, y, x2 - cx2, area.getHeight()));
            } else if (intersectsRight) {
                areas.add(new Rect2i(x, y, cx - x, area.getHeight()));
            } else {
                areas.add(new Rect2i(x, y, cx - x, area.getHeight()));
                areas.add(new Rect2i(cx2, y, x2 - cx2, area.getHeight()));
            }
        } else if (intersectsLeft && intersectsRight) {
            if (intersectsTop) {
                areas.add(new Rect2i(x, cy2, area.getWidth(), y2 - cy2));
            } else if (intersectsBottom) {
                areas.add(new Rect2i(x, y, area.getWidth(), cy - y));
            } else {
                areas.add(new Rect2i(x, y, area.getWidth(), cy - y));
                areas.add(new Rect2i(x, cy2, area.getWidth(), y2 - cy2));
            }
        } else if (intersectsTop && intersectsLeft) {
            areas.add(new Rect2i(x, cy2, area.getWidth(), y2 - cy2));
            areas.add(new Rect2i(cx2, y, x2 - cx2, cy2 - y));
        } else if (intersectsTop && intersectsRight) {
            areas.add(new Rect2i(x, y, cx - x, cy2 - y));
            areas.add(new Rect2i(x, cy2, area.getWidth(), y2 - cy2));
        } else if (intersectsBottom && intersectsLeft) {
            areas.add(new Rect2i(x, y, area.getWidth(), cy - y));
            areas.add(new Rect2i(cx2, cy, x2 - cx2, y2 - cy));
        } else if (intersectsBottom && intersectsRight) {
            areas.add(new Rect2i(x, y, area.getWidth(), cy - y));
            areas.add(new Rect2i(x, cy, cx - x, y2 - cy));
        } else if (intersectsTop) {
            areas.add(new Rect2i(x, y, cx - x, cy2 - y));
            areas.add(new Rect2i(x, cy2, area.getWidth(), y2 - cy2));
            areas.add(new Rect2i(cx2, y, x2 - cx2, cy2 - y));
        } else if (intersectsLeft) {
            areas.add(new Rect2i(x, y, area.getWidth(), cy - y));
            areas.add(new Rect2i(x, cy2, area.getWidth(), y2 - cy2));
            areas.add(new Rect2i(cx2, cy, x2 - cx2, coveredArea.getHeight()));
        } else if (intersectsBottom) {
            areas.add(new Rect2i(x, y, area.getWidth(), cy - y));
            areas.add(new Rect2i(x, cy, cx - x, y2 - cy));
            areas.add(new Rect2i(cx2, cy, x2 - cx2, y2 - cy));
        } else if (intersectsRight) {
            areas.add(new Rect2i(x, y, area.getWidth(), cy - y));
            areas.add(new Rect2i(x, cy, cx - x, coveredArea.getHeight()));
            areas.add(new Rect2i(x, cy2, area.getWidth(), y2 - cy2));
        } else {
            areas.add(new Rect2i(x, y, area.getWidth(), cy - y));
            areas.add(new Rect2i(x, cy, cx - x, coveredArea.getHeight()));
            areas.add(new Rect2i(x, cy2, area.getWidth(), y2 - cy2));
            areas.add(new Rect2i(cx2, cy, x2 - cx2, coveredArea.getHeight()));
        }
        return areas;
    }

    @FunctionalInterface
    public static interface TargetCreator<TARGET> {
        public TARGET create(IRecipeViewerGhostTarget.IGhostIngredientConsumer var1, Object var2, Rect2i var3);
    }

    private static class TargetInfo<TARGET> {
        private final TargetCreator<TARGET> targetCreator;
        private final IRecipeViewerGhostTarget.IGhostIngredientConsumer ghostHandler;
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private final Object supported;

        public TargetInfo(IRecipeViewerGhostTarget ghostTarget, IRecipeViewerGhostTarget.IGhostIngredientConsumer ghostHandler, int x, int y, int width, int height, Object supported, TargetCreator<TARGET> targetCreator) {
            this.ghostHandler = ghostHandler;
            this.targetCreator = targetCreator;
            this.supported = supported;
            int borderSize = ghostTarget.borderSize();
            this.x = x + borderSize;
            this.y = y + borderSize;
            this.width = width - 2 * borderSize;
            this.height = height - 2 * borderSize;
        }

        public List<TARGET> convertToTargets(List<Rect2i> coveredArea) {
            ArrayList<Rect2i> visibleAreas = new ArrayList<Rect2i>();
            GhostIngredientHandler.addVisibleAreas(visibleAreas, new Rect2i(this.x, this.y, this.width, this.height), coveredArea);
            ArrayList<TARGET> list = new ArrayList<TARGET>(visibleAreas.size());
            for (Rect2i visibleArea : visibleAreas) {
                list.add(this.targetCreator.create(this.ghostHandler, this.supported, visibleArea));
            }
            return list;
        }
    }
}

