/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import mekanism.client.model.MekanismJavaModel;
import mekanism.client.model.ModelPartData;
import mekanism.client.render.MekanismRenderType;
import mekanism.common.Mekanism;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ModelAtomicDisassembler
extends MekanismJavaModel {
    public static final ModelLayerLocation DISASSEMBLER_LAYER = new ModelLayerLocation(Mekanism.rl("atomic_disassembler"), "main");
    private static final ResourceLocation DISASSEMBLER_TEXTURE = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "atomic_disassembler.png");
    private static final ModelPartData HANDLE = new ModelPartData("handle", CubeListBuilder.create().texOffs(0, 10).addBox(0.0f, -1.0f, -3.0f, 1.0f, 16.0f, 1.0f), new ModelPartData[0]);
    private static final ModelPartData HANDLE_TOP = new ModelPartData("handleTop", CubeListBuilder.create().texOffs(34, 9).addBox(-0.5f, -3.5f, -3.5f, 2.0f, 5.0f, 2.0f), new ModelPartData[0]);
    private static final ModelPartData BLADE_BACK = new ModelPartData("bladeBack", CubeListBuilder.create().texOffs(42, 0).addBox(0.0f, -4.0f, -4.0f, 1.0f, 2.0f, 10.0f), new ModelPartData[0]);
    private static final ModelPartData HEAD = new ModelPartData("head", CubeListBuilder.create().texOffs(24, 0).addBox(-5.0f, -5.7f, -5.5f, 3.0f, 3.0f, 6.0f), PartPose.rotation((float)0.0f, (float)0.0f, (float)0.7853982f), new ModelPartData[0]);
    private static final ModelPartData NECK = new ModelPartData("neck", CubeListBuilder.create().addBox(-0.5f, -6.0f, -7.0f, 2.0f, 2.0f, 8.0f), new ModelPartData[0]);
    private static final ModelPartData BLADE_FRONT_UPPER = new ModelPartData("bladeFrontUpper", CubeListBuilder.create().texOffs(60, 0).addBox(0.0f, -0.5333334f, -9.6f, 1.0f, 3.0f, 1.0f), PartPose.rotation((float)-0.7853982f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    private static final ModelPartData BLADE_FRONT_LOWER = new ModelPartData("bladeFrontLower", CubeListBuilder.create().texOffs(58, 0).addBox(0.0f, -9.58f, -4.0f, 1.0f, 5.0f, 2.0f, new CubeDeformation(0.01f)), PartPose.rotation((float)0.7853982f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    private static final ModelPartData NECK_ANGLED = new ModelPartData("neckAngled", CubeListBuilder.create().texOffs(12, 0).addBox(-0.5f, -8.2f, -2.5f, 2.0f, 1.0f, 1.0f), PartPose.rotation((float)0.7853982f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    private static final ModelPartData BLADE_FRONT_CONNECTOR = new ModelPartData("bladeFrontConnector", CubeListBuilder.create().texOffs(56, 0).addBox(0.0f, -2.44f, -6.07f, 1.0f, 2.0f, 3.0f), new ModelPartData[0]);
    private static final ModelPartData BLADE_HOLDER_BACK = new ModelPartData("bladeHolderBack", CubeListBuilder.create().texOffs(42, 14).addBox(-0.5f, -4.5f, 3.5f, 2.0f, 1.0f, 1.0f), new ModelPartData[0]);
    private static final ModelPartData BLADE_HOLDER_MAIN = new ModelPartData("bladeHolderMain", CubeListBuilder.create().texOffs(30, 16).addBox(-0.5f, -3.5f, -1.5f, 2.0f, 1.0f, 4.0f), new ModelPartData[0]);
    private static final ModelPartData BLADE_HOLDER_FRONT = new ModelPartData("bladeHolderFront", CubeListBuilder.create().texOffs(42, 12).addBox(-0.5f, -4.5f, 1.5f, 2.0f, 1.0f, 1.0f), new ModelPartData[0]);
    private static final ModelPartData REAR_BAR = new ModelPartData("rearBar", CubeListBuilder.create().texOffs(4, 10).addBox(0.0f, -5.3f, 0.0f, 1.0f, 1.0f, 7.0f), new ModelPartData[0]);
    private static final ModelPartData BLADE_BACK_SMALL = new ModelPartData("bladeBackSmall", CubeListBuilder.create().texOffs(60, 0).addBox(0.0f, -4.0f, 6.0f, 1.0f, 1.0f, 1.0f), new ModelPartData[0]);
    private static final ModelPartData HANDLE_BASE = new ModelPartData("handleBase", CubeListBuilder.create().texOffs(26, 9).addBox(-0.5f, 15.0f, -3.5f, 2.0f, 4.0f, 2.0f), new ModelPartData[0]);
    private static final ModelPartData HANDLE_TOP_BACK = new ModelPartData("handleTopBack", CubeListBuilder.create().texOffs(37, 0).addBox(0.0f, -2.0f, -2.0f, 1.0f, 4.0f, 1.0f), new ModelPartData[0]);
    private final RenderType BLADE_RENDER_TYPE = MekanismRenderType.BLADE.apply(DISASSEMBLER_TEXTURE);
    private final RenderType RENDER_TYPE = this.renderType(DISASSEMBLER_TEXTURE);
    private final List<ModelPart> parts;
    private final List<ModelPart> bladeParts;

    public static LayerDefinition createLayerDefinition() {
        return ModelAtomicDisassembler.createLayerDefinition(64, 32, HANDLE, HANDLE_TOP, BLADE_BACK, HEAD, NECK, BLADE_FRONT_UPPER, BLADE_FRONT_LOWER, NECK_ANGLED, BLADE_FRONT_CONNECTOR, BLADE_HOLDER_BACK, BLADE_HOLDER_MAIN, BLADE_HOLDER_FRONT, REAR_BAR, BLADE_BACK_SMALL, HANDLE_BASE, HANDLE_TOP_BACK);
    }

    public ModelAtomicDisassembler(EntityModelSet entityModelSet) {
        super(RenderType::entitySolid);
        ModelPart root = entityModelSet.bakeLayer(DISASSEMBLER_LAYER);
        this.parts = ModelAtomicDisassembler.getRenderableParts(root, HANDLE, HANDLE_TOP, HEAD, NECK, REAR_BAR, NECK_ANGLED, BLADE_HOLDER_BACK, BLADE_HOLDER_MAIN, BLADE_HOLDER_FRONT, HANDLE_BASE, HANDLE_TOP_BACK);
        this.bladeParts = ModelAtomicDisassembler.getRenderableParts(root, BLADE_FRONT_CONNECTOR, BLADE_BACK, BLADE_FRONT_UPPER, BLADE_FRONT_LOWER, BLADE_BACK_SMALL);
    }

    public void render(@NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight, boolean hasEffect) {
        this.renderToBuffer(matrix, ModelAtomicDisassembler.getVertexConsumer(renderer, this.RENDER_TYPE, hasEffect), light, overlayLight, -1);
        ModelAtomicDisassembler.renderPartsToBuffer(this.bladeParts, matrix, ModelAtomicDisassembler.getVertexConsumer(renderer, this.BLADE_RENDER_TYPE, hasEffect), 0xF000F0, overlayLight, -1073741825);
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int light, int overlayLight, int color) {
        ModelAtomicDisassembler.renderPartsToBuffer(this.parts, poseStack, vertexConsumer, light, overlayLight, color);
    }
}

