/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.qio;

import java.util.ArrayList;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.ToggleButton;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.tab.GuiQIOFrequencyTab;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.qio.GuiQIOFilterHandler;
import mekanism.common.MekanismLang;
import mekanism.common.content.qio.IQIOFrequencyHolder;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.registries.MekanismSounds;
import mekanism.common.tile.qio.TileEntityQIORedstoneAdapter;
import mekanism.common.util.text.InputValidator;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class GuiQIORedstoneAdapter
extends GuiMekanismTile<TileEntityQIORedstoneAdapter, MekanismTileContainer<TileEntityQIORedstoneAdapter>> {
    private GuiTextField text;

    public GuiQIORedstoneAdapter(MekanismTileContainer<TileEntityQIORedstoneAdapter> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.dynamicSlots = true;
        this.imageHeight += 26;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiQIOFrequencyTab((IGuiWrapper)this, this.tile));
        this.addRenderableWidget(new GuiSlot(SlotType.NORMAL, this, 7, 30).setRenderHover(true)).click((element, mouseX, mouseY) -> {
            GuiQIORedstoneAdapter gui = (GuiQIORedstoneAdapter)element.gui();
            ItemStack stack = gui.getCarriedItem();
            if (stack.isEmpty() == GuiQIORedstoneAdapter.hasShiftDown()) {
                gui.updateStack(stack);
                return true;
            }
            return false;
        }, (Holder<SoundEvent>)MekanismSounds.BEEP).setGhostHandler(ingredient -> {
            this.updateStack((ItemStack)ingredient);
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI(MekanismSounds.BEEP, (float)1.0f));
        });
        this.addRenderableWidget(new ToggleButton((IGuiWrapper)this, 9, 64, 14, ((TileEntityQIORedstoneAdapter)this.tile)::isInverted, (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.INVERSE_BUTTON, ((GuiQIORedstoneAdapter)element.gui()).tile)))).setTooltip(MekanismLang.REDSTONE_ADAPTER_TOGGLE_SIGNAL);
        this.addRenderableWidget(new MekanismImageButton((IGuiWrapper)this, 9, 80, 14, this.getButtonLocation("fuzzy"), (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.QIO_REDSTONE_ADAPTER_FUZZY, ((GuiQIORedstoneAdapter)element.gui()).tile)))).setTooltip(MekanismLang.FUZZY_MODE);
        this.addRenderableWidget(new GuiInnerScreen((IGuiWrapper)this, 7, 16, this.imageWidth - 15, 12, GuiQIOFilterHandler.getFrequencyText((IQIOFrequencyHolder)((Object)this.tile))).tooltip(GuiQIOFilterHandler.getFrequencyTooltip((IQIOFrequencyHolder)((Object)this.tile))));
        this.addRenderableWidget(new GuiInnerScreen((IGuiWrapper)this, 27, 30, this.imageWidth - 27 - 8, 64, () -> {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            ItemStack itemType = ((TileEntityQIORedstoneAdapter)this.tile).getItemType();
            list.add((MutableComponent)(itemType.isEmpty() ? MekanismLang.QIO_ITEM_TYPE_UNDEFINED.translate() : itemType.getHoverName()));
            MekanismLang match = ((TileEntityQIORedstoneAdapter)this.tile).isInverted() ? MekanismLang.GENERIC_LESS_THAN : MekanismLang.GENERIC_GREATER_EQUAL;
            list.add(match.translate(MekanismLang.QIO_TRIGGER_COUNT, TextUtils.format(((TileEntityQIORedstoneAdapter)this.tile).getCount())));
            if (!itemType.isEmpty() && ((TileEntityQIORedstoneAdapter)this.tile).getQIOFrequency() != null) {
                list.add(MekanismLang.QIO_STORED_COUNT.translate(TextUtils.format(((TileEntityQIORedstoneAdapter)this.tile).getStoredCount())));
            }
            list.add(MekanismLang.QIO_FUZZY_MODE.translate(((TileEntityQIORedstoneAdapter)this.tile).getFuzzyMode()));
            return list;
        }).clearFormat());
        this.text = this.addRenderableWidget(new GuiTextField(this, 29, 80, this.imageWidth - 39, 12));
        this.text.setInputValidator(InputValidator.DIGIT).configureDigitalInput(this::setCount).setMaxLength(10);
        this.setInitialFocus((GuiEventListener)this.text);
    }

    private void updateStack(ItemStack stack) {
        PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteractionItem.QIO_REDSTONE_ADAPTER_STACK, (BlockEntity)this.tile, stack.copyWithCount(1)));
    }

    private void setCount() {
        if (!this.text.getText().isEmpty()) {
            long count = Long.parseLong(this.text.getText());
            PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.QIO_REDSTONE_ADAPTER_COUNT, (BlockEntity)this.tile, (int)Math.min(count, Integer.MAX_VALUE)));
            this.text.setText("");
        }
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.drawString(guiGraphics, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, this.titleTextColor());
        this.renderItem(guiGraphics, ((TileEntityQIORedstoneAdapter)this.tile).getItemType(), 8, 31);
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

