/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.machine;

import java.lang.ref.WeakReference;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.ItemStackToPigmentRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.client.gui.GuiConfigurableTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiHorizontalPowerBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiPigmentGauge;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.tab.GuiEnergyTab;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.recipe.lookup.IRecipeLookupHandler;
import mekanism.common.tile.machine.TileEntityPigmentExtractor;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class GuiPigmentExtractor
extends GuiConfigurableTile<TileEntityPigmentExtractor, MekanismTileContainer<TileEntityPigmentExtractor>> {
    public GuiPigmentExtractor(MekanismTileContainer<TileEntityPigmentExtractor> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiHorizontalPowerBar((IGuiWrapper)this, ((TileEntityPigmentExtractor)this.tile).getEnergyContainer(), 115, 75)).warning(WarningTracker.WarningType.NOT_ENOUGH_ENERGY, ((TileEntityPigmentExtractor)this.tile).getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY));
        this.addRenderableWidget(new GuiEnergyTab((IGuiWrapper)this, ((TileEntityPigmentExtractor)this.tile).getEnergyContainer(), ((TileEntityPigmentExtractor)this.tile)::getActive));
        this.addRenderableWidget(new GuiPigmentGauge(() -> ((TileEntityPigmentExtractor)this.tile).pigmentTank, () -> ((TileEntityPigmentExtractor)this.tile).getPigmentTanks(null), GaugeType.STANDARD, this, 131, 13)).warning(WarningTracker.WarningType.NO_SPACE_IN_OUTPUT, ((TileEntityPigmentExtractor)this.tile).getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE));
        this.addRenderableWidget(((GuiProgress)new GuiProgress(((TileEntityPigmentExtractor)this.tile)::getScaledProgress, ProgressType.LARGE_RIGHT, (IGuiWrapper)this, 64, 40).recipeViewerCategory((IRecipeLookupHandler)((Object)this.tile))).colored(new PigmentColorDetails())).warning(WarningTracker.WarningType.INPUT_DOESNT_PRODUCE_OUTPUT, ((TileEntityPigmentExtractor)this.tile).getWarningCheck(CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT));
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.drawString(guiGraphics, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, this.titleTextColor());
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }

    private class PigmentColorDetails
    implements GuiProgress.ColorDetails {
        private WeakReference<ItemStackToPigmentRecipe> cachedRecipe;

        private PigmentColorDetails() {
        }

        @Override
        public int getColorFrom() {
            return -1;
        }

        @Override
        public int getColorTo() {
            if (GuiPigmentExtractor.this.tile == null) {
                return -1;
            }
            if (((TileEntityPigmentExtractor)((GuiPigmentExtractor)GuiPigmentExtractor.this).tile).pigmentTank.isEmpty()) {
                IInventorySlot inputSlot = ((TileEntityPigmentExtractor)GuiPigmentExtractor.this.tile).getInputSlot();
                if (!inputSlot.isEmpty()) {
                    ItemStackToPigmentRecipe recipe;
                    ItemStack input = inputSlot.getStack();
                    if (this.cachedRecipe == null) {
                        recipe = this.getRecipeAndCache();
                    } else {
                        recipe = (ItemStackToPigmentRecipe)this.cachedRecipe.get();
                        if (recipe == null || !recipe.getInput().testType(input)) {
                            recipe = this.getRecipeAndCache();
                        }
                    }
                    if (recipe != null) {
                        return this.getColor(recipe.getOutput(input).getChemicalColorRepresentation());
                    }
                }
                return -1;
            }
            return this.getColor(((Pigment)((TileEntityPigmentExtractor)((GuiPigmentExtractor)GuiPigmentExtractor.this).tile).pigmentTank.getType()).getColorRepresentation());
        }

        private ItemStackToPigmentRecipe getRecipeAndCache() {
            ItemStackToPigmentRecipe recipe = ((TileEntityPigmentExtractor)GuiPigmentExtractor.this.tile).getRecipe(0);
            this.cachedRecipe = recipe == null ? null : new WeakReference<ItemStackToPigmentRecipe>(recipe);
            return recipe;
        }

        private int getColor(int tint) {
            if ((tint & 0xFF000000) == 0) {
                return 0xFF000000 | tint;
            }
            return tint;
        }
    }
}

