/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.machine;

import java.util.Collections;
import mekanism.client.gui.GuiConfigurableTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.button.FilterButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.scroll.GuiScrollBar;
import mekanism.client.gui.element.window.filter.GuiOredictionificatorFilter;
import mekanism.common.MekanismLang;
import mekanism.common.content.filter.FilterManager;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.oredictionificator.OredictionificatorItemFilter;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.tile.machine.TileEntityOredictionificator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class GuiOredictionificator
extends GuiConfigurableTile<TileEntityOredictionificator, MekanismTileContainer<TileEntityOredictionificator>> {
    private static final int FILTER_COUNT = 3;
    private GuiScrollBar scrollBar;

    public GuiOredictionificator(MekanismTileContainer<TileEntityOredictionificator> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.imageHeight += 64;
        this.inventoryLabelY = this.imageHeight - 94;
        this.imageWidth += 60;
        this.inventoryLabelX += 30;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiElementHolder(this, 9, 17, 204, 68));
        this.addRenderableWidget(new GuiElementHolder(this, 9, 85, 204, 22));
        FilterManager<OredictionificatorItemFilter> filterManager = ((TileEntityOredictionificator)this.tile).getFilterManager();
        this.scrollBar = this.addRenderableWidget(new GuiScrollBar((IGuiWrapper)this, 213, 17, 90, filterManager::count, () -> 3));
        this.addRenderableWidget(new GuiProgress(() -> ((TileEntityOredictionificator)this.tile).didProcess, ProgressType.LARGE_RIGHT, (IGuiWrapper)this, 94, 119));
        this.addRenderableWidget(new TranslationButton((IGuiWrapper)this, 10, 86, 202, 20, MekanismLang.BUTTON_NEW_FILTER, (element, mouseX, mouseY) -> {
            GuiOredictionificator gui = (GuiOredictionificator)element.gui();
            gui.addWindow(GuiOredictionificatorFilter.create(gui, (TileEntityOredictionificator)gui.tile));
            return true;
        }));
        for (int i = 0; i < 3; ++i) {
            this.addRenderableWidget(new FilterButton(this, 10, 18 + i * 22, 202, 22, i, this.scrollBar::getCurrentSelection, filterManager, this::onClick, index -> PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.TOGGLE_FILTER_STATE, (BlockEntity)this.tile, index)), filter -> {
                if (filter instanceof OredictionificatorItemFilter) {
                    OredictionificatorItemFilter oredictionificatorFilter = (OredictionificatorItemFilter)filter;
                    return Collections.singletonList((ItemStack)oredictionificatorFilter.getResult());
                }
                return Collections.emptyList();
            })).warning(WarningTracker.WarningType.INVALID_OREDICTIONIFICATOR_FILTER, filter -> filter != null && filter.isEnabled() && !filter.hasFilter());
        }
        this.trackWarning(WarningTracker.WarningType.INVALID_OREDICTIONIFICATOR_FILTER, () -> filterManager.anyEnabledMatch(filter -> !filter.hasFilter()));
    }

    protected void onClick(IFilter<?> filter, int index) {
        if (filter instanceof OredictionificatorItemFilter) {
            OredictionificatorItemFilter oredictionificatorFilter = (OredictionificatorItemFilter)filter;
            this.addWindow(GuiOredictionificatorFilter.edit(this, (TileEntityOredictionificator)this.tile, oredictionificatorFilter));
        }
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.drawString(guiGraphics, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, this.titleTextColor());
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double xDelta, double yDelta) {
        return super.mouseScrolled(mouseX, mouseY, xDelta, yDelta) || this.scrollBar.adjustScroll(yDelta);
    }
}

