/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window.filter.transporter;

import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.button.ColorButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TooltipToggleButton;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.window.filter.GuiFilterHelper;
import mekanism.client.gui.element.window.filter.transporter.GuiSorterFilerSelect;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.TransporterUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import mekanism.common.util.text.InputValidator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public interface GuiSorterFilterHelper
extends GuiFilterHelper<TileEntityLogisticalSorter>,
IFancyFontRenderer,
ContainerEventHandler {
    @Override
    public SorterFilter<?> getFilter();

    public boolean isSingleItem();

    default public void addSorterDefaults(IGuiWrapper gui, int slotOffset, UnaryOperator<GuiElement> childAdder, BiConsumer<GuiTextField, GuiTextField> rangeSetter) {
        int relativeX = this.getRelativeX();
        int relativeY = this.getRelativeY();
        int slotX = relativeX + 7;
        int colorSlotY = relativeY + slotOffset + 25;
        childAdder.apply(new GuiSlot(SlotType.NORMAL, gui, slotX, colorSlotY));
        childAdder.apply(new ColorButton(gui, slotX + 1, colorSlotY + 1, 16, 16, () -> ((SorterFilter)this.getFilter()).color, (element, mouseX, mouseY) -> {
            IFilter filter = this.getFilter();
            ((SorterFilter)filter).color = Screen.hasShiftDown() ? null : TransporterUtils.increment(((SorterFilter)filter).color);
            return true;
        }, (element, mouseX, mouseY) -> {
            IFilter filter = this.getFilter();
            ((SorterFilter)filter).color = TransporterUtils.decrement(((SorterFilter)filter).color);
            return true;
        }));
        ((GuiElement)childAdder.apply(new MekanismImageButton(gui, relativeX + 148, relativeY + 18, 11, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "default.png"), (element, mouseX, mouseY) -> {
            IFilter filter = this.getFilter();
            ((SorterFilter)filter).allowDefault = !((SorterFilter)filter).allowDefault;
            return true;
        }))).setTooltip(MekanismLang.FILTER_ALLOW_DEFAULT);
        int maxStackSizeDigits = Integer.toString(99).length();
        GuiTextField minField = new GuiTextField(gui, this, relativeX + 169, relativeY + 31, 20, 11);
        minField.setMaxLength(maxStackSizeDigits);
        minField.setInputValidator(InputValidator.DIGIT);
        minField.setText(Integer.toString(((SorterFilter)this.getFilter()).min));
        childAdder.apply(minField);
        GuiTextField maxField = new GuiTextField(gui, this, relativeX + 169, relativeY + 43, 20, 11);
        maxField.setMaxLength(maxStackSizeDigits);
        maxField.setInputValidator(InputValidator.DIGIT);
        maxField.setText(Integer.toString(((SorterFilter)this.getFilter()).max));
        childAdder.apply(maxField);
        rangeSetter.accept(minField, maxField);
        childAdder.apply(new TooltipToggleButton(gui, relativeX + 148, relativeY + 56, 11, 14, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "silk_touch.png"), () -> this.isSingleItem() && ((BaseFilter)this.getFilter()).isEnabled(), (element, mouseX, mouseY) -> {
            IFilter filter = this.getFilter();
            ((SorterFilter)filter).sizeMode = !((SorterFilter)filter).sizeMode;
            return true;
        }, (Component)MekanismLang.SORTER_SIZE_MODE_CONFLICT.translate(), (Component)MekanismLang.SORTER_SIZE_MODE.translate()));
    }

    default public GuiSorterFilerSelect getFilterSelect(IGuiWrapper gui, TileEntityLogisticalSorter tile) {
        return new GuiSorterFilerSelect(gui, tile);
    }

    default public void renderSorterForeground(GuiGraphics guiGraphics) {
        int relativeX = this.getRelativeX();
        int relativeY = this.getRelativeY();
        IFilter filter = this.getFilter();
        this.drawString(guiGraphics, BooleanStateDisplay.OnOff.of(((SorterFilter)filter).allowDefault).getTextComponent(), relativeX + 161, relativeY + 20, this.titleTextColor());
        this.drawString(guiGraphics, (Component)MekanismLang.MIN.translate(""), relativeX + 148, relativeY + 32, this.titleTextColor());
        this.drawString(guiGraphics, (Component)MekanismLang.MAX.translate(""), relativeX + 148, relativeY + 44, this.titleTextColor());
        if (this.isSingleItem() && ((SorterFilter)filter).sizeMode) {
            this.drawString(guiGraphics, (Component)MekanismLang.SORTER_FILTER_SIZE_MODE.translateColored(EnumColor.RED, BooleanStateDisplay.OnOff.ON), relativeX + 161, relativeY + 58, this.titleTextColor());
        } else {
            this.drawString(guiGraphics, BooleanStateDisplay.OnOff.of(((SorterFilter)filter).sizeMode).getTextComponent(), relativeX + 161, relativeY + 58, this.titleTextColor());
        }
    }
}

