/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window;

import java.util.Collections;
import mekanism.api.RelativeSide;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.ColorButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.SideDataButton;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.network.MekClickType;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.network.to_server.configuration_update.PacketEjectColor;
import mekanism.common.network.to_server.configuration_update.PacketInputColor;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GuiTransporterConfig<TILE extends TileEntityMekanism>
extends GuiWindow {
    private final TILE tile;

    public GuiTransporterConfig(IGuiWrapper gui, int x, int y, TILE tile, SelectedWindowData windowData) {
        super(gui, x, y, 156, 119, windowData);
        if (windowData.type != SelectedWindowData.WindowType.TRANSPORTER_CONFIG) {
            throw new IllegalArgumentException("Transporter configs must have a transporter config window type");
        }
        this.tile = tile;
        this.interactionStrategy = GuiWindow.InteractionStrategy.ALL;
        this.addChild(new GuiInnerScreen(gui, this.relativeX + 41, this.relativeY + 15, 74, 12, () -> Collections.singletonList(MekanismLang.STRICT_INPUT_ENABLED.translate(BooleanStateDisplay.OnOff.of(((ISideConfiguration)((Object)tile)).getEjector().hasStrictInput())))));
        this.addChild(new GuiSlot(SlotType.NORMAL, gui, this.relativeX + 111, this.relativeY + 48));
        this.addChild(new MekanismImageButton(gui, this.relativeX + 136, this.relativeY + 6, 14, 16, GuiTransporterConfig.getButtonLocation("exclamation"), (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.STRICT_INPUT, (BlockEntity)this.tile)))).setTooltip(MekanismLang.STRICT_INPUT);
        this.addChild(new ColorButton(gui, this.relativeX + 112, this.relativeY + 49, 16, 16, () -> ((ISideConfiguration)this.tile).getEjector().getOutputColor(), (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketEjectColor(this.tile.getBlockPos(), MekClickType.left(Screen.hasShiftDown()))), (element, mouseX, mouseY) -> PacketUtils.sendToServer(new PacketEjectColor(this.tile.getBlockPos(), MekClickType.RIGHT))));
        this.addSideDataButton(RelativeSide.BOTTOM, 41, 80);
        this.addSideDataButton(RelativeSide.TOP, 41, 34);
        this.addSideDataButton(RelativeSide.FRONT, 41, 57);
        this.addSideDataButton(RelativeSide.BACK, 18, 80);
        this.addSideDataButton(RelativeSide.LEFT, 18, 57);
        this.addSideDataButton(RelativeSide.RIGHT, 64, 57);
        ((MekanismContainer)((GuiMekanism)this.gui()).getMenu()).startTracking(0, ((ISideConfiguration)this.tile).getEjector());
        PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.CONTAINER_TRACK_EJECTOR, (BlockEntity)this.tile, 0));
    }

    private void addSideDataButton(RelativeSide side, int xPos, int yPos) {
        SideDataButton button = this.addChild(new SideDataButton(this.gui(), this.relativeX + xPos, this.relativeY + yPos, side, () -> ((ISideConfiguration)this.tile).getConfig().getDataType(TransmissionType.ITEM, side), () -> ((ISideConfiguration)this.tile).getEjector().getInputColor(side), (TileEntityMekanism)this.tile, PacketInputColor::new, false));
        if (!((ISideConfiguration)this.tile).getEjector().isInputSideEnabled(side)) {
            button.active = false;
        }
    }

    @Override
    public void close() {
        super.close();
        PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.CONTAINER_STOP_TRACKING, (BlockEntity)this.tile, 0));
        ((MekanismContainer)((GuiMekanism)this.gui()).getMenu()).stopTracking(0);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        this.drawTitleText(guiGraphics, (Component)MekanismLang.TRANSPORTER_CONFIG.translate(), 5.0f);
        this.drawCenteredText(guiGraphics, (Component)MekanismLang.INPUT.translate(), this.relativeX + 51, this.relativeY + 105, this.subheadingTextColor());
        this.drawCenteredText(guiGraphics, (Component)MekanismLang.OUTPUT.translate(), this.relativeX + 121, this.relativeY + 68, this.subheadingTextColor());
    }

    @Override
    protected int getTitlePadEnd() {
        return super.getTitlePadEnd() + 15;
    }
}

