/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window;

import java.util.function.Supplier;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.SelectedWindowData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class GuiConfirmationDialog
extends GuiWindow {
    private final IFancyFontRenderer.WrappedTextRenderer wrappedTextRenderer;

    private GuiConfirmationDialog(IGuiWrapper gui, int x, int y, int width, int height, Component title, Runnable onConfirm, DialogType type) {
        super(gui, x, y, width, height, SelectedWindowData.WindowType.CONFIRMATION);
        this.wrappedTextRenderer = new IFancyFontRenderer.WrappedTextRenderer((IFancyFontRenderer)this, title);
        this.active = true;
        this.addChild(new TranslationButton(gui, this.relativeX + width / 2 - 51, this.relativeY + height - 24, 50, 18, MekanismLang.BUTTON_CANCEL, this::close));
        this.addChild(new TranslationButton(gui, this.relativeX + width / 2 + 1, this.relativeY + height - 24, 50, 18, MekanismLang.BUTTON_CONFIRM, (element, mouseX, mouseY) -> {
            onConfirm.run();
            return this.close(element, mouseX, mouseY);
        }, type.getColorSupplier()));
    }

    public static void show(IGuiWrapper gui, Component title, Runnable onConfirm, DialogType type) {
        int width = 140;
        int height = 33 + IFancyFontRenderer.WrappedTextRenderer.calculateHeightRequired(gui.getFont(), title, width, (float)(width - 10));
        gui.addWindow(new GuiConfirmationDialog(gui, (gui.getXSize() - width) / 2, (gui.getYSize() - height) / 2, width, height, title, onConfirm, type));
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        this.wrappedTextRenderer.renderCentered(guiGraphics, (float)this.relativeX + (float)this.width / 2.0f, this.relativeY + 6, this.titleTextColor(), this.width - 10);
    }

    @Override
    public boolean isMouseOver(double mouseX, double mouseY) {
        return true;
    }

    @Override
    protected boolean isFocusOverlay() {
        return true;
    }

    public static enum DialogType {
        NORMAL(() -> null),
        DANGER(() -> EnumColor.RED);

        private final Supplier<EnumColor> colorSupplier;

        private DialogType(Supplier<EnumColor> colorSupplier) {
            this.colorSupplier = colorSupplier;
        }

        public Supplier<EnumColor> getColorSupplier() {
            return this.colorSupplier;
        }
    }
}

