/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.UnaryOperator;
import mekanism.api.IIncrementalEnum;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.config.MekanismConfig;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiEnergyTab
extends GuiTexturedElement {
    private static final Map<UnitDisplayUtils.EnergyUnit, ResourceLocation> ICONS = new EnumMap<UnitDisplayUtils.EnergyUnit, ResourceLocation>(UnitDisplayUtils.EnergyUnit.class);
    private final GuiTexturedElement.IInfoHandler infoHandler;
    private List<Component> lastInfo = Collections.emptyList();
    @Nullable
    private Tooltip lastTooltip;

    public GuiEnergyTab(IGuiWrapper gui, GuiTexturedElement.IInfoHandler handler) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_TAB, "energy_info.png"), gui, -26, 137, 26, 26);
        this.infoHandler = handler;
    }

    public GuiEnergyTab(IGuiWrapper gui, MachineEnergyContainer<?> energyContainer, FloatingLongSupplier lastEnergyUsed) {
        this(gui, () -> List.of(MekanismLang.USING.translate(EnergyDisplay.of(lastEnergyUsed.get())), MekanismLang.NEEDED.translate(EnergyDisplay.of(energyContainer.getNeeded()))));
    }

    public GuiEnergyTab(IGuiWrapper gui, MachineEnergyContainer<?> energyContainer, BooleanSupplier isActive) {
        this(gui, () -> {
            FloatingLong using = isActive.getAsBoolean() ? energyContainer.getEnergyPerTick() : FloatingLong.ZERO;
            return List.of(MekanismLang.USING.translate(EnergyDisplay.of(using)), MekanismLang.NEEDED.translate(EnergyDisplay.of(energyContainer.getNeeded())));
        });
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.blit(this.getResource(), this.relativeX, this.relativeY, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        ArrayList<Component> info = new ArrayList<Component>(this.infoHandler.getInfo());
        info.add((Component)MekanismLang.UNIT.translate(UnitDisplayUtils.EnergyUnit.getConfigured()));
        if (!info.equals(this.lastInfo)) {
            this.lastInfo = info;
            this.lastTooltip = TooltipUtils.create(info);
        }
        this.setTooltip(this.lastTooltip);
    }

    @Override
    protected ResourceLocation getResource() {
        return ICONS.computeIfAbsent(UnitDisplayUtils.EnergyUnit.getConfigured(), type -> MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_TAB, "energy_info_" + type.getTabName() + ".png"));
    }

    public void onClick(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.updateEnergyUnit(IIncrementalEnum::getNext);
        } else if (button == 1) {
            this.updateEnergyUnit(IIncrementalEnum::getPrevious);
        }
    }

    public boolean isValidClickButton(int button) {
        return button == 0 || button == 1;
    }

    private void updateEnergyUnit(UnaryOperator<UnitDisplayUtils.EnergyUnit> converter) {
        UnitDisplayUtils.EnergyUnit updated;
        UnitDisplayUtils.EnergyUnit current = UnitDisplayUtils.EnergyUnit.getConfigured();
        if (current != (updated = (UnitDisplayUtils.EnergyUnit)converter.apply(current))) {
            MekanismConfig.common.energyUnit.set(updated);
            MekanismConfig.common.save();
        }
    }
}

