/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.scroll;

import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.function.ObjIntConsumer;
import mekanism.api.Upgrade;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.scroll.GuiScrollList;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UpgradeUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiUpgradeScrollList
extends GuiScrollList {
    private static final ResourceLocation UPGRADE_SELECTION = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "upgrade_selection.png");
    private static final int TEXTURE_WIDTH = 58;
    private static final int TEXTURE_HEIGHT = 36;
    private final Map<Upgrade, Tooltip> tooltips = new EnumMap<Upgrade, Tooltip>(Upgrade.class);
    private final TileComponentUpgrade component;
    private final Runnable onSelectionChange;
    @Nullable
    private Upgrade selectedType;
    @Nullable
    private ScreenRectangle cachedTooltipRect;

    public GuiUpgradeScrollList(IGuiWrapper gui, int x, int y, int width, int height, TileComponentUpgrade component, Runnable onSelectionChange) {
        super(gui, x, y, width, height, 12, GuiElementHolder.HOLDER, 32);
        this.component = component;
        this.onSelectionChange = onSelectionChange;
    }

    private Set<Upgrade> getCurrentUpgrades() {
        return this.component.getInstalledTypes();
    }

    @Override
    protected int getMaxElements() {
        return this.getCurrentUpgrades().size();
    }

    @Override
    public boolean hasSelection() {
        return this.selectedType != null;
    }

    @Override
    protected void setSelected(int index) {
        Upgrade newSelection;
        Set<Upgrade> currentUpgrades = this.getCurrentUpgrades();
        if (index >= 0 && index < currentUpgrades.size() && this.selectedType != (newSelection = currentUpgrades.toArray(new Upgrade[0])[index])) {
            this.selectedType = newSelection;
            this.onSelectionChange.run();
        }
    }

    @Nullable
    public Upgrade getSelection() {
        return this.selectedType;
    }

    @Override
    public void clearSelection() {
        if (this.selectedType != null) {
            this.selectedType = null;
            this.onSelectionChange.run();
        }
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        this.forEachUpgrade((upgrade, multipliedElement) -> this.drawTextScaledBound(guiGraphics, (Component)TextComponentUtil.build(upgrade), this.relativeX + 13, this.relativeY + 3 + multipliedElement, this.titleTextColor(), 44.0f));
    }

    @Override
    @NotNull
    protected ScreenRectangle getTooltipRectangle(int mouseX, int mouseY) {
        return this.cachedTooltipRect == null ? super.getTooltipRectangle(mouseX, mouseY) : this.cachedTooltipRect;
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        if (mouseX >= this.getX() + 1 && mouseX < this.getX() + this.barXShift - 1) {
            int index;
            Upgrade[] upgrades = this.getCurrentUpgrades().toArray(new Upgrade[0]);
            int currentSelection = this.getCurrentSelection();
            for (int i = 0; i < this.getFocusedElements() && (index = currentSelection + i) <= upgrades.length - 1; ++i) {
                Upgrade upgrade = upgrades[index];
                int multipliedElement = this.elementHeight * i;
                if (mouseY < this.getY() + 1 + multipliedElement || mouseY >= this.getY() + 1 + multipliedElement + this.elementHeight) continue;
                this.cachedTooltipRect = new ScreenRectangle(this.getX() + 1, this.getY() + 1 + multipliedElement, this.barXShift - 2, this.elementHeight);
                this.setTooltip(this.tooltips.computeIfAbsent(upgrade, u -> TooltipUtils.create(u.getDescription())));
                return;
            }
        }
        this.cachedTooltipRect = null;
        this.clearTooltip();
    }

    @Override
    public void renderElements(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.hasSelection() && this.component.getUpgrades(this.getSelection()) == 0) {
            this.clearSelection();
        }
        this.forEachUpgrade((upgrade, multipliedElement) -> {
            int shiftedY = this.getY() + 1 + multipliedElement;
            int j = 1;
            if (upgrade == this.getSelection()) {
                j = 2;
            } else if (mouseX >= this.getX() + 1 && mouseX < this.getX() + this.barXShift - 1 && mouseY >= shiftedY && mouseY < shiftedY + this.elementHeight) {
                j = 0;
            }
            MekanismRenderer.color(guiGraphics, upgrade.getColor());
            guiGraphics.blit(UPGRADE_SELECTION, this.relativeX + 1, this.relativeY + 1 + multipliedElement, 0.0f, (float)(this.elementHeight * j), 58, this.elementHeight, 58, 36);
            MekanismRenderer.resetColor(guiGraphics);
        });
        this.forEachUpgrade((upgrade, multipliedElement) -> this.gui().renderItem(guiGraphics, UpgradeUtils.getStack(upgrade), this.relativeX + 3, this.relativeY + 3 + multipliedElement, 0.5f));
    }

    private void forEachUpgrade(ObjIntConsumer<Upgrade> consumer) {
        int index;
        Upgrade[] upgrades = this.getCurrentUpgrades().toArray(new Upgrade[0]);
        int currentSelection = this.getCurrentSelection();
        for (int i = 0; i < this.getFocusedElements() && (index = currentSelection + i) <= upgrades.length - 1; ++i) {
            consumer.accept(upgrades[index], this.elementHeight * i);
        }
    }

    @Override
    public void syncFrom(GuiElement element) {
        super.syncFrom(element);
        GuiUpgradeScrollList old = (GuiUpgradeScrollList)element;
        this.selectedType = old.selectedType;
        this.onSelectionChange.run();
    }
}

