/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom.module;

import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import mekanism.api.gear.IModule;
import mekanism.api.gear.config.ModuleBooleanConfig;
import mekanism.api.gear.config.ModuleColorConfig;
import mekanism.api.gear.config.ModuleConfig;
import mekanism.api.gear.config.ModuleEnumConfig;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.GuiModuleTweaker;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.custom.module.BooleanToggle;
import mekanism.client.gui.element.custom.module.ColorSelection;
import mekanism.client.gui.element.custom.module.EnumToggle;
import mekanism.client.gui.element.custom.module.MiniElement;
import mekanism.client.gui.element.scroll.GuiScrollList;
import mekanism.client.gui.element.scroll.GuiScrollableElement;
import mekanism.common.MekanismLang;
import mekanism.common.content.gear.Module;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiModuleScreen
extends GuiScrollableElement {
    private static final int ELEMENT_SPACER = 4;
    final Consumer<ModuleConfig<?>> saveCallback;
    private final Supplier<ItemStack> itemSupplier;
    private final GuiModuleTweaker.ArmorPreview armorPreview;
    @Nullable
    private Module<?> currentModule;
    private Map<ResourceLocation, MiniElement<?>> miniElements = new LinkedHashMap();
    private int maxElements;

    public GuiModuleScreen(IGuiWrapper gui, int x, int y, Supplier<ItemStack> itemSupplier, Consumer<ModuleConfig<?>> saveCallback, GuiModuleTweaker.ArmorPreview armorPreview) {
        this(gui, x, y, 102, 134, itemSupplier, saveCallback, armorPreview);
    }

    private GuiModuleScreen(IGuiWrapper gui, int x, int y, int width, int height, Supplier<ItemStack> itemSupplier, Consumer<ModuleConfig<?>> saveCallback, GuiModuleTweaker.ArmorPreview armorPreview) {
        super(GuiScrollList.SCROLL_LIST, gui, x, y, width, height, width - 6, 2, 4, 4, height - 4);
        this.itemSupplier = itemSupplier;
        this.saveCallback = saveCallback;
        this.armorPreview = armorPreview;
    }

    public void setModule(@Nullable Module<?> module) {
        LinkedHashMap newElements = new LinkedHashMap();
        if (module != null) {
            int startY = GuiModuleScreen.getStartY(module);
            for (ModuleConfig<?> configItem : module.getConfigs()) {
                ColorSelection element;
                MiniElement miniElement;
                if (configItem.isConfigDisabled()) continue;
                MutableComponent description = TextComponentUtil.translate(Util.makeDescriptionId((String)"module", (ResourceLocation)configItem.name()));
                ResourceLocation name = configItem.name();
                Objects.requireNonNull(configItem);
                int n = 0;
                block6: while (true) {
                    ModuleConfig<?> moduleConfig;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ModuleBooleanConfig.class, ModuleEnumConfig.class, ModuleColorConfig.class}, moduleConfig, n)) {
                        case 0: {
                            ModuleBooleanConfig config = (ModuleBooleanConfig)moduleConfig;
                            if (name.equals((Object)ModuleConfig.ENABLED_KEY) && module.getData().isNoDisable()) {
                                n = 1;
                                continue block6;
                            }
                            miniElement = new BooleanToggle(this, config, (Component)description, 2, startY);
                            break block6;
                        }
                        case 1: {
                            MiniElement<?> miniElement2;
                            ModuleEnumConfig config = (ModuleEnumConfig)moduleConfig;
                            EnumToggle toggle = new EnumToggle(this, config, (Component)description, 2, startY);
                            if (this.currentModule != null && this.currentModule.getData() == module.getData() && (miniElement2 = this.miniElements.get(name)) instanceof EnumToggle) {
                                EnumToggle enumToggle = (EnumToggle)miniElement2;
                                toggle.dragging = enumToggle.dragging;
                            }
                            miniElement = toggle;
                            break block6;
                        }
                        case 2: {
                            ModuleColorConfig config = (ModuleColorConfig)moduleConfig;
                            miniElement = new ColorSelection(this, config, (Component)description, 2, startY, this.armorPreview);
                            break block6;
                        }
                        default: {
                            miniElement = null;
                            break block6;
                        }
                    }
                    break;
                }
                if ((element = miniElement) == null) continue;
                newElements.put(name, element);
                startY += ((MiniElement)element).getNeededHeight() + 4;
            }
            this.maxElements = newElements.isEmpty() ? startY : startY - 4;
        } else {
            this.maxElements = 0;
        }
        this.currentModule = module;
        this.miniElements = newElements;
    }

    private static int getStartY(@Nullable IModule<?> module) {
        int startY = 5;
        if (module != null) {
            if (module.getData().isExclusive(-1)) {
                startY += 13;
            }
            if (module.getData().getMaxStackSize() > 1) {
                startY += 13;
            }
        }
        return startY;
    }

    @Override
    protected int getMaxElements() {
        return this.maxElements;
    }

    @Override
    protected int getFocusedElements() {
        return this.height - 2;
    }

    @Override
    protected int getScrollElementScaler() {
        return 10;
    }

    int getScreenWidth() {
        return this.barXShift;
    }

    @Nullable
    public IModule<?> getCurrentModule() {
        return this.currentModule;
    }

    public ItemStack getContainerStack() {
        return this.itemSupplier.get();
    }

    @Override
    public void syncFrom(GuiElement element) {
        GuiModuleScreen old = (GuiModuleScreen)element;
        this.setModule(old.currentModule);
        super.syncFrom(element);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double xDelta, double yDelta) {
        return this.isMouseOver(mouseX, mouseY) && this.adjustScroll(yDelta) || super.mouseScrolled(mouseX, mouseY, xDelta, yDelta);
    }

    @Override
    public void onClick(double mouseX, double mouseY, int button) {
        super.onClick(mouseX, mouseY, button);
        mouseY += (double)this.getCurrentSelection();
        for (MiniElement<?> element : this.miniElements.values()) {
            element.click(mouseX, mouseY);
        }
    }

    @Override
    public void onRelease(double mouseX, double mouseY) {
        super.onRelease(mouseX, mouseY);
        mouseY += (double)this.getCurrentSelection();
        for (MiniElement<?> element : this.miniElements.values()) {
            element.release(mouseX, mouseY);
        }
    }

    @Override
    public void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
        super.onDrag(mouseX, mouseY, deltaX, deltaY);
        mouseY += (double)this.getCurrentSelection();
        for (MiniElement<?> element : this.miniElements.values()) {
            element.onDrag(mouseX, mouseY, deltaX, deltaY);
        }
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mx, int my, float partialTicks) {
        super.drawBackground(guiGraphics, mx, my, partialTicks);
        this.renderBackgroundTexture(guiGraphics, GuiInnerScreen.SCREEN, GuiInnerScreen.SCREEN_SIZE, GuiInnerScreen.SCREEN_SIZE);
        this.drawScrollBar(guiGraphics, 6, 6);
        this.scissorScreen(guiGraphics, mx, my, (g, mouseX, mouseY, module, shift) -> GuiModuleScreen.getStartY(module), MiniElement::renderBackground);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mx, int my) {
        super.renderForeground(guiGraphics, mx, my);
        this.scissorScreen(guiGraphics, mx, my, (g, mouseX, mouseY, module, shift) -> {
            int startY = 5;
            if (module != null) {
                if (module.getData().isExclusive(-1)) {
                    if (startY + 13 > shift) {
                        this.drawTextWithScale(g, (Component)MekanismLang.MODULE_EXCLUSIVE.translate(), this.relativeX + 5, this.relativeY + startY, 6511572, 0.8f);
                    }
                    startY += 13;
                }
                if (module.getData().getMaxStackSize() > 1) {
                    if (startY + 13 > shift) {
                        this.drawTextWithScale(g, (Component)MekanismLang.MODULE_INSTALLED.translate(module.getInstalledCount()), this.relativeX + 5, this.relativeY + startY, this.screenTextColor(), 0.8f);
                    }
                    startY += 13;
                }
            }
            return startY;
        }, MiniElement::renderForeground);
    }

    private void scissorScreen(GuiGraphics guiGraphics, int mouseX, int mouseY, ScissorRender renderer, ScissorMiniElementRender miniElementRender) {
        guiGraphics.enableScissor(0, this.getY() + 1, guiGraphics.guiWidth(), this.getBottom() - 1);
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        int shift = this.getCurrentSelection();
        pose.translate(0.0f, (float)(-shift), 0.0f);
        int startY = renderer.render(guiGraphics, mouseX, mouseY += shift, this.currentModule, shift);
        for (MiniElement<?> element : this.miniElements.values()) {
            if (startY >= shift + this.height) break;
            if (startY + element.getNeededHeight() > shift) {
                miniElementRender.render(element, guiGraphics, mouseX, mouseY);
            }
            startY += element.getNeededHeight() + 4;
        }
        pose.popPose();
        guiGraphics.disableScissor();
    }

    @FunctionalInterface
    private static interface ScissorRender {
        public int render(GuiGraphics var1, int var2, int var3, @Nullable IModule<?> var4, int var5);
    }

    @FunctionalInterface
    private static interface ScissorMiniElementRender {
        public void render(MiniElement<?> var1, GuiGraphics var2, int var3, int var4);
    }
}

