/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.button;

import java.util.Objects;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MekanismButton
extends GuiElement {
    @NotNull
    private final GuiElement.IClickable onLeftClick;
    @Nullable
    private final GuiElement.IClickable onRightClick;

    public MekanismButton(IGuiWrapper gui, int x, int y, int width, int height, Component text, @NotNull GuiElement.IClickable onLeftClick) {
        this(gui, x, y, width, height, text, onLeftClick, onLeftClick);
    }

    public MekanismButton(IGuiWrapper gui, int x, int y, int width, int height, Component text, @NotNull GuiElement.IClickable onLeftClick, @Nullable GuiElement.IClickable onRightClick) {
        super(gui, x, y, width, height, text);
        this.onLeftClick = Objects.requireNonNull(onLeftClick, "Buttons must have a left click behavior");
        this.onRightClick = onRightClick;
        this.clickSound = SoundEvents.UI_BUTTON_CLICK;
        this.setButtonBackground(GuiElement.ButtonBackground.DEFAULT);
    }

    @Override
    public MekanismButton setTooltip(ILangEntry langEntry) {
        super.setTooltip(langEntry);
        return this;
    }

    public void onClick(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.onLeftClick.onClick(this, mouseX, mouseY);
        } else if (button == 1 && this.onRightClick != null) {
            this.onRightClick.onClick(this, mouseX, mouseY);
        }
    }

    public boolean isValidClickButton(int button) {
        return button == 0 || button == 1 && this.onRightClick != null;
    }

    @Override
    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.active && this.visible && this.isFocused() && CommonInputs.selected((int)keyCode)) {
            this.playDownSound(minecraft.getSoundManager());
            return this.onLeftClick.onClick(this, (double)this.getButtonX() + (double)this.getButtonWidth() / 2.0, (double)this.getButtonY() + (double)this.getButtonHeight() / 2.0);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

