/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.button;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.RadioButton;
import mekanism.client.gui.element.slot.GuiSequencedSlotDisplay;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.content.filter.FilterManager;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.content.oredictionificator.OredictionificatorFilter;
import mekanism.common.content.oredictionificator.OredictionificatorItemFilter;
import mekanism.common.content.qio.filter.QIOItemStackFilter;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterButton
extends MekanismButton {
    private static final ResourceLocation TEXTURE = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "filter_holder.png");
    protected static final int TEXTURE_WIDTH = 156;
    protected static final int TEXTURE_HEIGHT = 58;
    protected final FilterManager<?> filterManager;
    private final GuiSequencedSlotDisplay slotDisplay;
    private final ObjIntConsumer<IFilter<?>> onPress;
    private final IntSupplier filterIndex;
    private final RadioButton toggleButton;
    private final GuiSlot slot;
    private final int index;
    private IFilter<?> prevFilter;

    @Nullable
    private static IFilter<?> getFilter(FilterManager<?> filterManager, int index) {
        if (index >= 0 && index < filterManager.count()) {
            return (IFilter)filterManager.getFilters().get(index);
        }
        return null;
    }

    public FilterButton(IGuiWrapper gui, int x, int y, int width, int height, int index, IntSupplier filterIndex, FilterManager<?> filterManager, ObjIntConsumer<IFilter<?>> onPress, IntConsumer toggleButtonPress, Function<IFilter<?>, List<ItemStack>> renderStackSupplier) {
        super(gui, x, y, width, height, (Component)Component.empty(), (element, mouseX, mouseY) -> {
            FilterButton button = (FilterButton)element;
            int actualIndex = button.filterIndex.getAsInt() + button.index;
            button.onPress.accept(FilterButton.getFilter(button.filterManager, actualIndex), actualIndex);
            return true;
        });
        this.index = index;
        this.filterIndex = filterIndex;
        this.filterManager = filterManager;
        this.onPress = onPress;
        this.slot = this.addChild(new GuiSlot(SlotType.NORMAL, gui, this.relativeX + 2, this.relativeY + 2));
        this.slotDisplay = this.addChild(new GuiSequencedSlotDisplay(gui, this.relativeX + 3, this.relativeY + 3, () -> (List)renderStackSupplier.apply(this.getFilter())));
        this.toggleButton = this.addChild(new RadioButton(gui, this.relativeX + this.width - 8 - this.getToggleXShift(), this.relativeY + this.height / 2 - 4, this::isEnabled, (element, mouseX, mouseY) -> {
            toggleButtonPress.accept(this.getActualIndex());
            return true;
        }, (Component)MekanismLang.FILTER_STATE.translate(EnumColor.BRIGHT_GREEN, MekanismLang.MODULE_ENABLED_LOWER), (Component)MekanismLang.FILTER_STATE.translate(EnumColor.RED, MekanismLang.MODULE_DISABLED_LOWER)));
        this.setButtonBackground(GuiElement.ButtonBackground.NONE);
    }

    private boolean isEnabled() {
        IFilter<?> filter = this.getFilter();
        return filter != null && filter.isEnabled();
    }

    protected int getToggleXShift() {
        return 4;
    }

    protected int getActualIndex() {
        return this.filterIndex.getAsInt() + this.index;
    }

    @Nullable
    protected IFilter<?> getFilter() {
        return FilterButton.getFilter(this.filterManager, this.getActualIndex());
    }

    public FilterButton warning(@NotNull WarningTracker.WarningType type, @NotNull Predicate<IFilter<?>> hasWarning) {
        this.slot.warning(type, () -> hasWarning.test(this.getFilter()));
        return this;
    }

    protected void setVisibility(boolean visible) {
        this.visible = visible;
        this.slot.visible = visible;
        this.slotDisplay.visible = visible;
        this.toggleButton.visible = visible;
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.setVisibility(this.getFilter() != null);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.blit(TEXTURE, this.getButtonX(), this.getButtonY(), this.getButtonWidth(), this.getButtonHeight(), 0.0f, this.isMouseOverCheckWindows(mouseX, mouseY) ? 0.0f : 29.0f, 156, 29, 156, 58);
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        IFilter<?> filter = this.getFilter();
        if (filter != this.prevFilter) {
            this.slotDisplay.updateStackList();
            this.prevFilter = filter;
        }
        IFilter<?> iFilter = filter;
        int n = 0;
        MutableComponent filterDescriptor = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IItemStackFilter.class, ITagFilter.class, IModIDFilter.class, OredictionificatorFilter.class}, iFilter, n)) {
            case 0 -> {
                IItemStackFilter item = (IItemStackFilter)iFilter;
                yield item.getItemStack().getHoverName();
            }
            case 1 -> {
                ITagFilter tag = (ITagFilter)iFilter;
                yield Component.literal((String)tag.getTagName());
            }
            case 2 -> {
                IModIDFilter modId = (IModIDFilter)iFilter;
                yield Component.literal((String)modId.getModID());
            }
            case 3 -> {
                OredictionificatorFilter oredictionificatorFilter = (OredictionificatorFilter)iFilter;
                yield Component.literal((String)oredictionificatorFilter.getFilterText());
            }
            default -> Component.empty();
        };
        this.drawFilterDescriptor(guiGraphics, (Component)filterDescriptor, this.relativeX, this.relativeY);
        if (filter instanceof SorterFilter) {
            SorterFilter sorterFilter = (SorterFilter)filter;
            int colorX = this.relativeX + 22;
            int colorY = this.relativeY + 13;
            GuiUtils.drawOutline(guiGraphics, colorX, colorY, 6, 6, -13027015);
            if (sorterFilter.color != null) {
                guiGraphics.fill(colorX + 1, colorY + 1, colorX + 5, colorY + 5, MekanismRenderer.getColorARGB(sorterFilter.color, 1.0f));
            }
            this.drawTextWithScale(guiGraphics, (Component)(sorterFilter.color == null ? MekanismLang.NO_COLOR.translate() : sorterFilter.color.getName()), this.relativeX + 22 + 8, this.relativeY + 12, this.titleTextColor(), 0.5f);
        } else if (filter instanceof OredictionificatorItemFilter) {
            OredictionificatorItemFilter oreDictFilter = (OredictionificatorItemFilter)filter;
            this.drawTextWithScale(guiGraphics, (Component)((ItemStack)oreDictFilter.getResult()).getHoverName().copy().append(" (" + BuiltInRegistries.ITEM.getKey((Object)oreDictFilter.getResultElement()).getNamespace() + ")"), this.relativeX + 22, this.relativeY + 12, this.titleTextColor(), 0.5f);
        } else if (filter instanceof QIOItemStackFilter) {
            QIOItemStackFilter itemFilter = (QIOItemStackFilter)filter;
            if (itemFilter.fuzzyMode) {
                this.drawTextWithScale(guiGraphics, (Component)MekanismLang.FUZZY_MODE.translate(), this.relativeX + 22, this.relativeY + 12, this.titleTextColor(), 0.5f);
            }
        }
    }

    private void drawFilterDescriptor(GuiGraphics guiGraphics, Component component, int x, int y) {
        this.drawTextScaledBound(guiGraphics, component, x + 22, y + 3, this.titleTextColor(), this.getMaxLength());
    }

    protected int getMaxLength() {
        return this.width - 22 - 8 - 11;
    }
}

