/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.bar;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiTankBar;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.network.to_server.PacketDropperUse;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.text.TextUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiChemicalBar<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
extends GuiTankBar<STACK> {
    public GuiChemicalBar(IGuiWrapper gui, GuiTankBar.TankInfoProvider<STACK> infoProvider, int x, int y, int width, int height, boolean horizontal) {
        super(gui, infoProvider, x, y, width, height, horizontal);
    }

    @Override
    protected boolean isEmpty(STACK stack) {
        return ((ChemicalStack)stack).isEmpty();
    }

    @Override
    @Nullable
    protected PacketDropperUse.TankType getType(STACK stack) {
        Object type;
        Object CHEMICAL = type = ((ChemicalStack)((GuiTankBar.TankInfoProvider)this.getHandler()).getStack()).getChemical();
        Objects.requireNonNull(CHEMICAL);
        Object CHEMICAL2 = CHEMICAL;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Gas.class, InfuseType.class, Pigment.class, Slurry.class}, CHEMICAL2, n)) {
            case 0 -> {
                Gas gas = (Gas)CHEMICAL2;
                yield PacketDropperUse.TankType.GAS_TANK;
            }
            case 1 -> {
                InfuseType infuseType = (InfuseType)CHEMICAL2;
                yield PacketDropperUse.TankType.INFUSION_TANK;
            }
            case 2 -> {
                Pigment pigment = (Pigment)CHEMICAL2;
                yield PacketDropperUse.TankType.PIGMENT_TANK;
            }
            case 3 -> {
                Slurry slurry = (Slurry)CHEMICAL2;
                yield PacketDropperUse.TankType.SLURRY_TANK;
            }
            default -> null;
        };
    }

    @Override
    protected List<Component> getTooltip(STACK stack) {
        List<Component> tooltips = super.getTooltip(stack);
        ChemicalUtil.addChemicalDataToTooltip(tooltips, ((ChemicalStack)stack).getChemical(), Minecraft.getInstance().options.advancedItemTooltips);
        return tooltips;
    }

    @Override
    protected void applyRenderColor(GuiGraphics guiGraphics, STACK stack) {
        MekanismRenderer.color(guiGraphics, stack);
    }

    @Override
    protected TextureAtlasSprite getIcon(STACK stack) {
        return MekanismRenderer.getChemicalTexture(((ChemicalStack)stack).getChemical());
    }

    public static <STACK extends ChemicalStack<?>, TANK extends IChemicalTank<?, STACK>> GuiTankBar.TankInfoProvider<STACK> getProvider(final TANK tank, final List<TANK> tanks) {
        return new GuiTankBar.TankInfoProvider<STACK>(){

            @Override
            @NotNull
            public STACK getStack() {
                return tank.getStack();
            }

            @Override
            public int getTankIndex() {
                return tanks.indexOf(tank);
            }

            @Override
            public Component getTooltip() {
                if (tank.isEmpty()) {
                    return MekanismLang.EMPTY.translate();
                }
                if (tank.getStored() == Long.MAX_VALUE) {
                    return MekanismLang.GENERIC_STORED.translate(tank.getType(), MekanismLang.INFINITE);
                }
                return MekanismLang.GENERIC_STORED_MB.translate(tank.getType(), TextUtils.format(tank.getStored()));
            }

            @Override
            public double getLevel() {
                return (double)tank.getStored() / (double)tank.getCapacity();
            }
        };
    }
}

