/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiScalableElement;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.client.recipe_viewer.interfaces.IRecipeViewerRecipeArea;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiInnerScreen
extends GuiScalableElement
implements IRecipeViewerRecipeArea<GuiInnerScreen> {
    public static final ResourceLocation SCREEN = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "inner_screen.png");
    public static int SCREEN_SIZE = 32;
    private List<Component> lastInfo = Collections.emptyList();
    @Nullable
    private Tooltip lastTooltip;
    private Supplier<List<Component>> renderStrings;
    private Supplier<List<Component>> tooltipStrings;
    private IRecipeViewerRecipeType<?>[] recipeCategories;
    private boolean centerY;
    private int spacing = 1;
    private int padding = 3;
    private float textScale = 1.0f;

    public GuiInnerScreen(IGuiWrapper gui, int x, int y, int width, int height) {
        super(SCREEN, gui, x, y, width, height, SCREEN_SIZE, SCREEN_SIZE);
    }

    public GuiInnerScreen(IGuiWrapper gui, int x, int y, int width, int height, Supplier<List<Component>> renderStrings) {
        this(gui, x, y, width, height);
        this.renderStrings = renderStrings;
        this.defaultFormat();
    }

    public GuiInnerScreen tooltip(Supplier<List<Component>> tooltipStrings) {
        this.tooltipStrings = tooltipStrings;
        this.active = true;
        return this;
    }

    public GuiInnerScreen spacing(int spacing) {
        this.spacing = spacing;
        return this;
    }

    public GuiInnerScreen padding(int padding) {
        this.padding = padding;
        return this;
    }

    public GuiInnerScreen textScale(float textScale) {
        this.textScale = textScale;
        return this;
    }

    public GuiInnerScreen centerY() {
        this.centerY = true;
        return this;
    }

    public GuiInnerScreen clearFormat() {
        this.centerY = false;
        return this;
    }

    public GuiInnerScreen defaultFormat() {
        return this.padding(5).spacing(3).textScale(0.8f).centerY();
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        if (this.renderStrings != null) {
            List<Component> list = this.renderStrings.get();
            float startY = this.relativeY + this.padding;
            if (this.centerY) {
                int listSize = list.size();
                int totalHeight = listSize * 8 + this.spacing * (listSize - 1);
                startY = (float)this.relativeY + (float)(this.getHeight() - totalHeight) / 2.0f;
            }
            for (Component text : this.renderStrings.get()) {
                this.drawText(guiGraphics, text, this.relativeX + this.padding, startY);
                startY += (float)(8 + this.spacing);
            }
        }
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        if (this.tooltipStrings != null) {
            List<Component> list = this.tooltipStrings.get();
            if (!list.equals(this.lastInfo)) {
                this.lastInfo = list;
                this.lastTooltip = TooltipUtils.create(list);
            }
        } else {
            this.lastInfo = Collections.emptyList();
            this.lastTooltip = null;
        }
        this.setTooltip(this.lastTooltip);
    }

    private void drawText(GuiGraphics guiGraphics, Component text, float x, float y) {
        this.drawScaledTextScaledBound(guiGraphics, text, x, y, this.screenTextColor(), this.getMaxTextWidth(), this.textScale);
    }

    protected int getMaxTextWidth() {
        return this.getWidth() - this.padding * 2;
    }

    @Override
    @NotNull
    public GuiInnerScreen recipeViewerCategories(IRecipeViewerRecipeType<?> ... recipeCategories) {
        this.recipeCategories = recipeCategories;
        return this;
    }

    @Override
    @Nullable
    public IRecipeViewerRecipeType<?>[] getRecipeCategories() {
        return this.recipeCategories;
    }

    @Override
    public boolean isMouseOverRecipeViewerArea(double mouseX, double mouseY) {
        return this.visible && mouseX >= (double)this.getX() && mouseY >= (double)this.getY() && mouseX < (double)this.getRight() && mouseY < (double)this.getBottom();
    }
}

