/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Set;
import mekanism.common.inventory.container.slot.IVirtualSlot;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualSlotContainerScreen<T extends AbstractContainerMenu>
extends AbstractContainerScreen<T> {
    public VirtualSlotContainerScreen(T container, Inventory inv, Component titleIn) {
        super(container, inv, titleIn);
    }

    protected abstract boolean isMouseOverSlot(@NotNull Slot var1, double var2, double var4);

    @Deprecated
    @Nullable
    protected Slot findSlot(double mouseX, double mouseY) {
        for (Slot slot : this.menu.slots) {
            if (!slot.isActive() || !this.isMouseOverSlot(slot, mouseX, mouseY)) continue;
            return slot;
        }
        return null;
    }

    @Deprecated
    protected final boolean isHovering(@NotNull Slot slot, double mouseX, double mouseY) {
        boolean mouseOver = this.isMouseOverSlot(slot, mouseX, mouseY);
        if (mouseOver && slot instanceof IVirtualSlot) {
            if (this.hoveredSlot == null && slot.isActive()) {
                this.hoveredSlot = slot;
            }
            return false;
        }
        return mouseOver;
    }

    @Deprecated
    protected final void renderFloatingItem(@NotNull GuiGraphics guiGraphics, @NotNull ItemStack stack, int x, int y, @Nullable String altText) {
        if (!stack.isEmpty()) {
            Slot slot;
            if (stack == this.snapbackItem && (slot = this.snapbackEnd) instanceof IVirtualSlot) {
                IVirtualSlot returningVirtualSlot = (IVirtualSlot)slot;
                float f = (float)(Util.getMillis() - this.snapbackTime) / 100.0f;
                if (f >= 1.0f) {
                    this.snapbackItem = ItemStack.EMPTY;
                    return;
                }
                int xOffset = returningVirtualSlot.getActualX() - this.snapbackStartX;
                int yOffset = returningVirtualSlot.getActualY() - this.snapbackStartY;
                x = this.snapbackStartX + (int)((float)xOffset * f);
                y = this.snapbackStartY + (int)((float)yOffset * f);
            }
            super.renderFloatingItem(guiGraphics, stack, x, y, altText);
        }
    }

    @Deprecated
    protected final void renderSlot(@NotNull GuiGraphics graphics, @NotNull Slot slot) {
        if (!(slot instanceof IVirtualSlot)) {
            super.renderSlot(graphics, slot);
            return;
        }
        IVirtualSlot virtualSlot = (IVirtualSlot)slot;
        ItemStack currentStack = slot.getItem();
        boolean shouldDrawOverlay = false;
        boolean skipStackRendering = slot == this.clickedSlot && !this.draggingItem.isEmpty() && !this.isSplittingStack;
        ItemStack heldStack = this.menu.getCarried();
        String s = null;
        if (slot == this.clickedSlot && !this.draggingItem.isEmpty() && this.isSplittingStack && !currentStack.isEmpty()) {
            currentStack = currentStack.copyWithCount(currentStack.getCount() / 2);
        } else if (this.isQuickCrafting && this.quickCraftSlots.contains(slot) && !heldStack.isEmpty()) {
            if (this.quickCraftSlots.size() == 1) {
                return;
            }
            if (AbstractContainerMenu.canItemQuickReplace((Slot)slot, (ItemStack)heldStack, (boolean)true) && this.menu.canDragTo(slot)) {
                int max = Math.min(heldStack.getMaxStackSize(), slot.getMaxStackSize(heldStack));
                int placed = AbstractContainerMenu.getQuickCraftPlaceCount((Set)this.quickCraftSlots, (int)this.quickCraftingType, (ItemStack)heldStack) + currentStack.getCount();
                if (placed > max) {
                    placed = max;
                    s = ChatFormatting.YELLOW.toString() + max;
                }
                currentStack = heldStack.copyWithCount(placed);
                shouldDrawOverlay = true;
            } else {
                this.quickCraftSlots.remove(slot);
                this.recalculateQuickCraftRemaining();
            }
        }
        virtualSlot.updateRenderInfo(skipStackRendering ? ItemStack.EMPTY : currentStack, shouldDrawOverlay, s);
    }

    public boolean slotClicked(@NotNull Slot slot, int button) {
        InputConstants.Key mouseKey = InputConstants.Type.MOUSE.getOrCreate(button);
        boolean pickBlockButton = this.minecraft.options.keyPickItem.isActiveAndMatches(mouseKey);
        long time = Util.getMillis();
        this.doubleclick = this.lastClickSlot == slot && time - this.lastClickTime < 250L && this.lastClickButton == button;
        this.skipNextRelease = false;
        if (button != 0 && button != 1 && !pickBlockButton) {
            this.checkHotbarMouseClicked(button);
        } else if (slot.index != -1) {
            if (((Boolean)this.minecraft.options.touchscreen().get()).booleanValue()) {
                if (slot.hasItem()) {
                    this.clickedSlot = slot;
                    this.draggingItem = ItemStack.EMPTY;
                    this.isSplittingStack = button == 1;
                } else {
                    this.clickedSlot = null;
                }
            } else if (!this.isQuickCrafting) {
                if (this.menu.getCarried().isEmpty()) {
                    if (pickBlockButton) {
                        this.slotClicked(slot, slot.index, button, ClickType.CLONE);
                    } else {
                        ClickType clicktype = ClickType.PICKUP;
                        if (Screen.hasShiftDown()) {
                            this.lastQuickMoved = slot.hasItem() ? slot.getItem().copy() : ItemStack.EMPTY;
                            clicktype = ClickType.QUICK_MOVE;
                        }
                        this.slotClicked(slot, slot.index, button, clicktype);
                    }
                    this.skipNextRelease = true;
                } else {
                    this.isQuickCrafting = true;
                    this.quickCraftingButton = button;
                    this.quickCraftSlots.clear();
                    if (button == 0) {
                        this.quickCraftingType = 0;
                    } else if (button == 1) {
                        this.quickCraftingType = 1;
                    } else if (pickBlockButton) {
                        this.quickCraftingType = 2;
                    }
                }
            }
        }
        this.lastClickSlot = slot;
        this.lastClickTime = time;
        this.lastClickButton = button;
        return true;
    }
}

