/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.SelectedWindowData;
import mekanism.common.inventory.warning.WarningTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IGuiWrapper
extends ContainerEventHandler {
    @NotNull
    default public ItemStack getCarriedItem() {
        return ItemStack.EMPTY;
    }

    public int getGuiLeft();

    public int getGuiTop();

    public int getXSize();

    public int getYSize();

    default public void addWindow(GuiWindow window) {
        Mekanism.logger.error("Tried to call 'addWindow' but unsupported in {}", (Object)this.getClass().getName());
    }

    default public void removeWindow(GuiWindow window) {
        Mekanism.logger.error("Tried to call 'removeWindow' but unsupported in {}", (Object)this.getClass().getName());
    }

    default public boolean currentlyQuickCrafting() {
        return false;
    }

    @Nullable
    default public GuiWindow getWindowHovering(double mouseX, double mouseY) {
        return null;
    }

    @NotNull
    default public BooleanSupplier trackWarning(@NotNull WarningTracker.WarningType type, @NotNull BooleanSupplier warningSupplier) {
        Mekanism.logger.error("Tried to call 'trackWarning' but unsupported in {}", (Object)this.getClass().getName());
        return warningSupplier;
    }

    public Font getFont();

    default public void renderItem(GuiGraphics guiGraphics, @NotNull ItemStack stack, int xAxis, int yAxis) {
        this.renderItem(guiGraphics, stack, xAxis, yAxis, 1.0f);
    }

    default public void renderItem(GuiGraphics guiGraphics, @NotNull ItemStack stack, int xAxis, int yAxis, float scale) {
        GuiUtils.renderItem(guiGraphics, stack, xAxis, yAxis, scale, this.getFont(), null, false);
    }

    default public void renderItemTooltip(GuiGraphics guiGraphics, @NotNull ItemStack stack, int xAxis, int yAxis) {
        guiGraphics.renderTooltip(this.getFont(), stack, xAxis, yAxis);
    }

    default public void renderItemTooltipWithExtra(GuiGraphics guiGraphics, @NotNull ItemStack stack, int xAxis, int yAxis, List<Component> toAppend) {
        if (toAppend.isEmpty()) {
            this.renderItemTooltip(guiGraphics, stack, xAxis, yAxis);
        } else {
            ArrayList<Component> tooltip = new ArrayList<Component>(Screen.getTooltipFromItem((Minecraft)Minecraft.getInstance(), (ItemStack)stack));
            tooltip.addAll(toAppend);
            guiGraphics.renderTooltip(this.getFont(), tooltip, stack.getTooltipImage(), stack, xAxis, yAxis);
        }
    }

    default public void renderItemWithOverlay(GuiGraphics guiGraphics, @NotNull ItemStack stack, int xAxis, int yAxis, float scale, @Nullable String text) {
        GuiUtils.renderItem(guiGraphics, stack, xAxis, yAxis, scale, this.getFont(), text, true);
    }

    default public void setSelectedWindow(SelectedWindowData selectedWindow) {
        Mekanism.logger.error("Tried to call 'setSelectedWindow' but unsupported in {}", (Object)this.getClass().getName());
    }
}

