/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.Collections;
import java.util.List;
import java.util.function.BooleanSupplier;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiDownArrow;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiHorizontalRateBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.tab.GuiHeatTab;
import mekanism.client.gui.element.tab.GuiWarningTab;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.recipe_viewer.type.RecipeViewerRecipeType;
import mekanism.common.MekanismLang;
import mekanism.common.content.evaporation.EvaporationMultiblockData;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.warning.IWarningTracker;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.tile.multiblock.TileEntityThermalEvaporationController;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class GuiThermalEvaporationController
extends GuiMekanismTile<TileEntityThermalEvaporationController, MekanismTileContainer<TileEntityThermalEvaporationController>> {
    public GuiThermalEvaporationController(MekanismTileContainer<TileEntityThermalEvaporationController> container, Inventory inv, Component title) {
        super(container, inv, title);
        this.inventoryLabelY += 2;
        this.titleLabelY = 4;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiInnerScreen((IGuiWrapper)this, 48, 19, 80, 40, () -> {
            EvaporationMultiblockData multiblock = (EvaporationMultiblockData)((TileEntityThermalEvaporationController)this.tile).getMultiblock();
            return List.of(MekanismLang.MULTIBLOCK_FORMED.translate(), MekanismLang.EVAPORATION_HEIGHT.translate(multiblock.height()), MekanismLang.TEMPERATURE.translate(MekanismUtils.getTemperatureDisplay(multiblock.getTemperature(), UnitDisplayUtils.TemperatureUnit.KELVIN, true)), MekanismLang.FLUID_PRODUCTION.translate((double)Math.round(multiblock.lastGain * 100.0) / 100.0));
        }).spacing(1).recipeViewerCategories(new IRecipeViewerRecipeType[]{RecipeViewerRecipeType.EVAPORATING}));
        this.addRenderableWidget(new GuiDownArrow(this, 32, 39));
        this.addRenderableWidget(new GuiDownArrow(this, 136, 39));
        this.addRenderableWidget(new GuiHorizontalRateBar(this, new GuiBar.IBarInfoHandler(){

            @Override
            public Component getTooltip() {
                return MekanismUtils.getTemperatureDisplay(((EvaporationMultiblockData)((TileEntityThermalEvaporationController)GuiThermalEvaporationController.this.tile).getMultiblock()).getTemperature(), UnitDisplayUtils.TemperatureUnit.KELVIN, true);
            }

            @Override
            public double getLevel() {
                return Math.min(1.0, ((EvaporationMultiblockData)((TileEntityThermalEvaporationController)GuiThermalEvaporationController.this.tile).getMultiblock()).getTemperature() / 3000.0);
            }
        }, 48, 63)).warning(WarningTracker.WarningType.INPUT_DOESNT_PRODUCE_OUTPUT, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT));
        this.addRenderableWidget(new GuiFluidGauge(() -> ((EvaporationMultiblockData)((TileEntityThermalEvaporationController)this.tile).getMultiblock()).inputTank, () -> ((EvaporationMultiblockData)((TileEntityThermalEvaporationController)this.tile).getMultiblock()).getFluidTanks(null), GaugeType.STANDARD, this, 6, 13)).warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT));
        this.addRenderableWidget(new GuiFluidGauge(() -> ((EvaporationMultiblockData)((TileEntityThermalEvaporationController)this.tile).getMultiblock()).outputTank, () -> ((EvaporationMultiblockData)((TileEntityThermalEvaporationController)this.tile).getMultiblock()).getFluidTanks(null), GaugeType.STANDARD, this, 152, 13)).warning(WarningTracker.WarningType.NO_SPACE_IN_OUTPUT, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE));
        this.addRenderableWidget(new GuiHeatTab(this, () -> {
            Component environment = MekanismUtils.getTemperatureDisplay(((EvaporationMultiblockData)((TileEntityThermalEvaporationController)this.tile).getMultiblock()).lastEnvironmentLoss, UnitDisplayUtils.TemperatureUnit.KELVIN, false);
            return Collections.singletonList(MekanismLang.DISSIPATED_RATE.translate(environment));
        }));
    }

    private BooleanSupplier getWarningCheck(CachedRecipe.OperationTracker.RecipeError error) {
        return () -> ((EvaporationMultiblockData)((TileEntityThermalEvaporationController)this.tile).getMultiblock()).hasWarning(error);
    }

    @Override
    protected void addWarningTab(IWarningTracker warningTracker) {
        this.addRenderableWidget(new GuiWarningTab(this, warningTracker, 137));
    }

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        this.renderTitleText(guiGraphics);
        this.drawString(guiGraphics, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, this.titleTextColor());
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
    }
}

