/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.FilterButton;
import mekanism.client.gui.element.button.MovableFilterButton;
import mekanism.client.gui.element.scroll.GuiScrollBar;
import mekanism.common.content.filter.FilterManager;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.PacketUtils;
import mekanism.common.network.to_server.PacketGuiInteract;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GuiFilterHolder<FILTER extends IFilter<?>, TILE extends TileEntityMekanism, CONTAINER extends MekanismTileContainer<TILE>>
extends GuiMekanismTile<TILE, CONTAINER> {
    private static final int FILTER_COUNT = 4;
    private GuiScrollBar scrollBar;

    protected GuiFilterHolder(CONTAINER container, Inventory inv, Component title) {
        super(container, inv, title);
        this.imageHeight += 88;
        this.imageWidth += 100;
        this.inventoryLabelX += 50;
        this.inventoryLabelY = this.imageHeight - 94;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        super.addGuiElements();
        this.addRenderableWidget(new GuiInnerScreen(this, 9, 17, 85, 140));
        this.addRenderableWidget(new GuiElementHolder(this, 95, 17, 158, 118));
        this.addRenderableWidget(new GuiElementHolder(this, 95, 135, 158, 22));
        FilterManager<FILTER> filterManager = this.getFilterManager();
        this.scrollBar = this.addRenderableWidget(new GuiScrollBar((IGuiWrapper)this, 253, 17, 140, filterManager::count, () -> 4));
        for (int i = 0; i < 4; ++i) {
            this.addFilterButton(new MovableFilterButton((IGuiWrapper)this, 96, 18 + i * 29, i, this.scrollBar::getCurrentSelection, filterManager, index -> {
                if (index > 0) {
                    PacketGuiInteract.GuiInteraction interaction = GuiFilterHolder.hasShiftDown() ? PacketGuiInteract.GuiInteraction.MOVE_FILTER_TO_TOP : PacketGuiInteract.GuiInteraction.MOVE_FILTER_UP;
                    PacketUtils.sendToServer(new PacketGuiInteract(interaction, (BlockEntity)this.tile, index));
                }
            }, index -> {
                if (index < filterManager.count() - 1) {
                    PacketGuiInteract.GuiInteraction interaction = GuiFilterHolder.hasShiftDown() ? PacketGuiInteract.GuiInteraction.MOVE_FILTER_TO_BOTTOM : PacketGuiInteract.GuiInteraction.MOVE_FILTER_DOWN;
                    PacketUtils.sendToServer(new PacketGuiInteract(interaction, (BlockEntity)this.tile, index));
                }
            }, this::onClick, index -> PacketUtils.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.TOGGLE_FILTER_STATE, (BlockEntity)this.tile, index)), this::getRenderStacks));
        }
    }

    private List<ItemStack> getRenderStacks(@Nullable IFilter<?> filter) {
        if (filter != null) {
            IFilter<?> iFilter = filter;
            Objects.requireNonNull(iFilter);
            IFilter<?> iFilter2 = iFilter;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IItemStackFilter.class, ITagFilter.class, IModIDFilter.class}, iFilter2, n)) {
                case 0 -> {
                    IItemStackFilter itemFilter = (IItemStackFilter)iFilter2;
                    yield List.of(itemFilter.getItemStack());
                }
                case 1 -> {
                    ITagFilter tagFilter = (ITagFilter)iFilter2;
                    yield this.getTagStacks(tagFilter.getTagName());
                }
                case 2 -> {
                    IModIDFilter modIDFilter = (IModIDFilter)iFilter2;
                    yield this.getModIDStacks(modIDFilter.getModID());
                }
                default -> Collections.emptyList();
            };
        }
        return Collections.emptyList();
    }

    protected FilterButton addFilterButton(FilterButton button) {
        return this.addRenderableWidget(button);
    }

    protected FilterManager<FILTER> getFilterManager() {
        return ((ITileFilterHolder)((Object)this.tile)).getFilterManager();
    }

    protected abstract void onClick(IFilter<?> var1, int var2);

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double xDelta, double yDelta) {
        return super.mouseScrolled(mouseX, mouseY, xDelta, yDelta) || this.scrollBar.adjustScroll(yDelta);
    }

    protected abstract List<ItemStack> getTagStacks(String var1);

    protected abstract List<ItemStack> getModIDStacks(String var1);

    @Override
    protected void drawForegroundText(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.drawForegroundText(guiGraphics, mouseX, mouseY);
        this.drawString(guiGraphics, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, this.titleTextColor());
    }
}

