/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.security;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.Locale;
import java.util.function.IntFunction;
import mekanism.api.IIncrementalEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.text.APILang;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.ILangEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

@NothingNullByDefault
public enum SecurityMode implements IIncrementalEnum<SecurityMode>,
IHasTextComponent,
StringRepresentable
{
    PUBLIC(APILang.PUBLIC, EnumColor.BRIGHT_GREEN),
    PRIVATE(APILang.PRIVATE, EnumColor.RED),
    TRUSTED(APILang.TRUSTED, EnumColor.INDIGO);

    public static final Codec<SecurityMode> CODEC;
    public static final IntFunction<SecurityMode> BY_ID;
    public static final StreamCodec<ByteBuf, SecurityMode> STREAM_CODEC;
    private final String serializedName = this.name().toLowerCase(Locale.ROOT);
    private final ILangEntry langEntry;
    private final EnumColor color;

    private SecurityMode(ILangEntry langEntry, EnumColor color) {
        this.langEntry = langEntry;
        this.color = color;
    }

    @Override
    public Component getTextComponent() {
        return this.langEntry.translateColored(this.color);
    }

    @Override
    public SecurityMode byIndex(int index) {
        return BY_ID.apply(index);
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    static {
        CODEC = StringRepresentable.fromEnum(SecurityMode::values);
        BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])SecurityMode.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
    }
}

