/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.creator;

import java.util.Map;
import java.util.Optional;
import mekanism.api.IMekanismAccess;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.ingredients.GasStackIngredient;
import mekanism.api.recipes.ingredients.InfusionStackIngredient;
import mekanism.api.recipes.ingredients.PigmentStackIngredient;
import mekanism.api.recipes.ingredients.SlurryStackIngredient;
import mekanism.api.recipes.ingredients.chemical.IGasIngredient;
import mekanism.api.recipes.ingredients.chemical.IInfusionIngredient;
import mekanism.api.recipes.ingredients.chemical.IPigmentIngredient;
import mekanism.api.recipes.ingredients.chemical.ISlurryIngredient;
import mekanism.api.recipes.ingredients.creator.IChemicalIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IChemicalStackIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IFluidStackIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IItemStackIngredientCreator;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponentType;
import org.jetbrains.annotations.Nullable;

public class IngredientCreatorAccess {
    private IngredientCreatorAccess() {
    }

    public static IChemicalStackIngredientCreator<?, ?, ?, ?> getCreatorForType(ChemicalType chemicalType) {
        return switch (chemicalType) {
            default -> throw new MatchException(null, null);
            case ChemicalType.GAS -> IngredientCreatorAccess.gasStack();
            case ChemicalType.INFUSION -> IngredientCreatorAccess.infusionStack();
            case ChemicalType.PIGMENT -> IngredientCreatorAccess.pigmentStack();
            case ChemicalType.SLURRY -> IngredientCreatorAccess.slurryStack();
        };
    }

    public static IItemStackIngredientCreator item() {
        return IMekanismAccess.INSTANCE.itemStackIngredientCreator();
    }

    public static IFluidStackIngredientCreator fluid() {
        return IMekanismAccess.INSTANCE.fluidStackIngredientCreator();
    }

    public static IChemicalStackIngredientCreator<Gas, GasStack, IGasIngredient, GasStackIngredient> gasStack() {
        return IMekanismAccess.INSTANCE.gasStackIngredientCreator();
    }

    public static IChemicalIngredientCreator<Gas, IGasIngredient> gas() {
        return IMekanismAccess.INSTANCE.gasIngredientCreator();
    }

    public static IChemicalStackIngredientCreator<InfuseType, InfusionStack, IInfusionIngredient, InfusionStackIngredient> infusionStack() {
        return IMekanismAccess.INSTANCE.infusionStackIngredientCreator();
    }

    public static IChemicalIngredientCreator<InfuseType, IInfusionIngredient> infusion() {
        return IMekanismAccess.INSTANCE.infusionIngredientCreator();
    }

    public static IChemicalStackIngredientCreator<Pigment, PigmentStack, IPigmentIngredient, PigmentStackIngredient> pigmentStack() {
        return IMekanismAccess.INSTANCE.pigmentStackIngredientCreator();
    }

    public static IChemicalIngredientCreator<Pigment, IPigmentIngredient> pigment() {
        return IMekanismAccess.INSTANCE.pigmentIngredientCreator();
    }

    public static IChemicalStackIngredientCreator<Slurry, SlurryStack, ISlurryIngredient, SlurryStackIngredient> slurryStack() {
        return IMekanismAccess.INSTANCE.slurryStackIngredientCreator();
    }

    public static IChemicalIngredientCreator<Slurry, ISlurryIngredient> slurry() {
        return IMekanismAccess.INSTANCE.slurryIngredientCreator();
    }

    @Nullable
    static DataComponentPredicate getComponentPatchPredicate(DataComponentPatch patch) {
        if (!patch.isEmpty()) {
            DataComponentPredicate.Builder builder = DataComponentPredicate.builder();
            for (Map.Entry entry : patch.entrySet()) {
                Optional value = (Optional)entry.getValue();
                if (!value.isPresent()) continue;
                builder.expect((DataComponentType)entry.getKey(), value.get());
            }
            return builder.build();
        }
        return null;
    }
}

