/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.creator;

import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.chemical.IChemicalIngredient;
import mekanism.api.recipes.ingredients.creator.IChemicalIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IIngredientCreator;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagKey;

@NothingNullByDefault
public interface IChemicalStackIngredientCreator<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends IChemicalIngredient<CHEMICAL, INGREDIENT>, STACK_INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK, INGREDIENT>>
extends IIngredientCreator<CHEMICAL, STACK, STACK_INGREDIENT> {
    public IChemicalIngredientCreator<CHEMICAL, INGREDIENT> chemicalCreator();

    @Override
    default public STACK_INGREDIENT from(STACK instance) {
        Objects.requireNonNull(instance, "ChemicalStackIngredients cannot be created from a null ChemicalStack.");
        return this.from(((ChemicalStack)instance).getChemical(), ((ChemicalStack)instance).getAmount());
    }

    @Override
    default public STACK_INGREDIENT from(CHEMICAL instance, int amount) {
        return this.from(instance, (long)amount);
    }

    default public STACK_INGREDIENT from(IChemicalProvider<CHEMICAL> provider, long amount) {
        Objects.requireNonNull(provider, "ChemicalStackIngredients cannot be created from a null chemical provider.");
        return this.from(this.chemicalCreator().of(provider), amount);
    }

    @Override
    default public STACK_INGREDIENT from(int amount, CHEMICAL ... chemicals) {
        return this.from((long)amount, (IChemicalProvider<CHEMICAL>[])chemicals);
    }

    default public STACK_INGREDIENT from(long amount, IChemicalProvider<CHEMICAL> ... chemicals) {
        if (chemicals.length == 0) {
            throw new IllegalArgumentException("Attempted to create an ChemicalStackIngredients with no chemicals.");
        }
        return this.from(this.chemicalCreator().of(chemicals), amount);
    }

    default public STACK_INGREDIENT fromHolder(Holder<CHEMICAL> instance, long amount) {
        return this.from((INGREDIENT)((IChemicalProvider)instance.value()), amount);
    }

    @Override
    default public STACK_INGREDIENT from(TagKey<CHEMICAL> tag, int amount) {
        return this.from((INGREDIENT)tag, (long)amount);
    }

    default public STACK_INGREDIENT from(TagKey<CHEMICAL> tag, long amount) {
        Objects.requireNonNull(tag, "ChemicalStackIngredients cannot be created from a null tag.");
        return this.from(this.chemicalCreator().tag(tag), amount);
    }

    public STACK_INGREDIENT from(INGREDIENT var1, long var2);
}

