/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.creator;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.recipes.ingredients.chemical.IChemicalIngredient;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;

@NothingNullByDefault
public interface IChemicalIngredientCreator<CHEMICAL extends Chemical<CHEMICAL>, INGREDIENT extends IChemicalIngredient<CHEMICAL, INGREDIENT>> {
    public MapCodec<INGREDIENT> singleOrTagCodec();

    public MapCodec<INGREDIENT> mapCodecNonEmpty();

    public Codec<List<INGREDIENT>> listCodec();

    public Codec<List<INGREDIENT>> listCodecNonEmpty();

    public Codec<List<INGREDIENT>> listCodecMultipleElements();

    public Codec<INGREDIENT> codec();

    public Codec<INGREDIENT> codecNonEmpty();

    public StreamCodec<RegistryFriendlyByteBuf, INGREDIENT> streamCodec();

    public INGREDIENT empty();

    default public INGREDIENT of() {
        return this.empty();
    }

    default public INGREDIENT of(ChemicalStack<CHEMICAL> stack) {
        return this.of((IChemicalProvider<CHEMICAL>)stack.getChemical());
    }

    default public INGREDIENT of(IChemicalProvider<CHEMICAL> chemicalProvider) {
        return this.of(((Chemical)chemicalProvider.getChemical()).getAsHolder());
    }

    public INGREDIENT of(Holder<CHEMICAL> var1);

    public INGREDIENT tag(TagKey<CHEMICAL> var1);

    default public INGREDIENT of(ChemicalStack<CHEMICAL> ... chemicals) {
        return this.of(Arrays.stream(chemicals).map(ChemicalStack::getChemical));
    }

    default public INGREDIENT of(IChemicalProvider<CHEMICAL> ... chemicalProviders) {
        return this.of(Arrays.stream(chemicalProviders));
    }

    default public INGREDIENT of(Stream<? extends IChemicalProvider<CHEMICAL>> chemicalProviders) {
        return (INGREDIENT)this.ofIngredients(chemicalProviders.map(this::of));
    }

    default public INGREDIENT ofIngredients(INGREDIENT ... children) {
        if (children.length == 0) {
            return this.empty();
        }
        if (children.length == 1) {
            return children[0];
        }
        return this.compound(List.of(children));
    }

    default public INGREDIENT ofIngredients(List<? extends INGREDIENT> children) {
        if (children.isEmpty()) {
            return this.empty();
        }
        if (children.size() == 1) {
            return (INGREDIENT)((IChemicalIngredient)children.getFirst());
        }
        return this.compound(List.copyOf(children));
    }

    default public INGREDIENT ofIngredients(Stream<? extends INGREDIENT> children) {
        return this.ofIngredients(children.toList());
    }

    public INGREDIENT compound(List<INGREDIENT> var1);

    public INGREDIENT difference(INGREDIENT var1, INGREDIENT var2);

    public INGREDIENT intersection(INGREDIENT ... var1);

    public INGREDIENT intersection(List<? extends INGREDIENT> var1);

    default public INGREDIENT intersection(Stream<? extends INGREDIENT> ingredients) {
        return this.intersection(ingredients.toList());
    }
}

