/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.chemical;

import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import java.util.stream.Stream;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.IChemicalIngredient;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract class TagChemicalIngredient<CHEMICAL extends Chemical<CHEMICAL>, INGREDIENT extends IChemicalIngredient<CHEMICAL, INGREDIENT>>
extends ChemicalIngredient<CHEMICAL, INGREDIENT> {
    private final TagKey<CHEMICAL> tag;

    @ApiStatus.Internal
    protected static <CHEMICAL extends Chemical<CHEMICAL>, TAG extends TagChemicalIngredient<CHEMICAL, ?>> MapCodec<TAG> codec(ResourceKey<? extends Registry<CHEMICAL>> registryName, Function<TagKey<CHEMICAL>, TAG> constructor) {
        return TagKey.codec(registryName).xmap(constructor, TagChemicalIngredient::tag).fieldOf("tag");
    }

    @ApiStatus.Internal
    protected TagChemicalIngredient(TagKey<CHEMICAL> tag) {
        this.tag = tag;
    }

    @Override
    public final boolean test(CHEMICAL chemical) {
        return ((Chemical)chemical).is(this.tag());
    }

    @Override
    public final Stream<CHEMICAL> generateChemicals() {
        return this.registry().getTag(this.tag()).stream().flatMap(HolderSet::stream).map(Holder::value);
    }

    public final TagKey<CHEMICAL> tag() {
        return this.tag;
    }

    protected abstract Registry<CHEMICAL> registry();

    @Override
    public int hashCode() {
        return this.tag.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.tag.equals(((TagChemicalIngredient)obj).tag);
    }
}

