/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.chemical;

import java.util.stream.Stream;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.IChemicalIngredient;
import net.minecraft.core.Holder;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract class SingleChemicalIngredient<CHEMICAL extends Chemical<CHEMICAL>, INGREDIENT extends IChemicalIngredient<CHEMICAL, INGREDIENT>>
extends ChemicalIngredient<CHEMICAL, INGREDIENT> {
    private final Holder<CHEMICAL> chemical;

    @ApiStatus.Internal
    protected SingleChemicalIngredient(Holder<CHEMICAL> chemical) {
        if (chemical.is(MekanismAPI.EMPTY_CHEMICAL_NAME)) {
            throw new IllegalStateException("SingleChemicalIngredient must not be constructed with mekanism:empty, use IChemicalIngredientCreator.empty() instead!");
        }
        this.chemical = chemical;
    }

    @Override
    public final boolean test(CHEMICAL chemical) {
        return chemical == this.chemical.value();
    }

    @Override
    public final Stream<CHEMICAL> generateChemicals() {
        return Stream.of((Chemical)this.chemical.value());
    }

    public final Holder<CHEMICAL> chemical() {
        return this.chemical;
    }

    @Override
    public int hashCode() {
        return ((Chemical)this.chemical.value()).hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.chemical.is(((SingleChemicalIngredient)obj).chemical);
    }
}

