/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.chemical;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import mekanism.api.recipes.ingredients.chemical.IChemicalIngredient;
import mekanism.api.recipes.ingredients.creator.IChemicalIngredientCreator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract class DifferenceChemicalIngredient<CHEMICAL extends Chemical<CHEMICAL>, INGREDIENT extends IChemicalIngredient<CHEMICAL, INGREDIENT>>
extends ChemicalIngredient<CHEMICAL, INGREDIENT> {
    private final INGREDIENT base;
    private final INGREDIENT subtracted;

    @ApiStatus.Internal
    protected static <INGREDIENT extends IChemicalIngredient<?, INGREDIENT>, DIFFERENCE extends DifferenceChemicalIngredient<?, INGREDIENT>> MapCodec<DIFFERENCE> codec(IChemicalIngredientCreator<?, INGREDIENT> creator, BiFunction<INGREDIENT, INGREDIENT, DIFFERENCE> constructor) {
        return RecordCodecBuilder.mapCodec(builder -> builder.group((App)creator.codecNonEmpty().fieldOf("base").forGetter(DifferenceChemicalIngredient::base), (App)creator.codecNonEmpty().fieldOf("subtracted").forGetter(DifferenceChemicalIngredient::subtracted)).apply((Applicative)builder, constructor));
    }

    @ApiStatus.Internal
    protected DifferenceChemicalIngredient(INGREDIENT base, INGREDIENT subtracted) {
        this.base = base;
        this.subtracted = subtracted;
    }

    @Override
    public final Stream<CHEMICAL> generateChemicals() {
        return this.base().generateChemicals().filter(this.subtracted().negate());
    }

    @Override
    public final boolean test(CHEMICAL chemical) {
        return this.base().test(chemical) && !this.subtracted().test(chemical);
    }

    public final INGREDIENT base() {
        return this.base;
    }

    public final INGREDIENT subtracted() {
        return this.subtracted;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base, this.subtracted);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DifferenceChemicalIngredient other = (DifferenceChemicalIngredient)obj;
        return this.base.equals(other.base) && this.subtracted.equals(other.subtracted);
    }
}

