/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.slurry.IEmptySlurryProvider;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.chemical.ISlurryIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class SlurryStackIngredient
extends ChemicalStackIngredient<Slurry, SlurryStack, ISlurryIngredient>
implements IEmptySlurryProvider {
    public static final Codec<SlurryStackIngredient> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCreatorAccess.slurry().mapCodecNonEmpty().forGetter(ChemicalStackIngredient::ingredient), (App)SerializerHelper.POSITIVE_LONG_CODEC.fieldOf("amount").forGetter(ChemicalStackIngredient::amount)).apply((Applicative)instance, SlurryStackIngredient::new));
    public static final Codec<SlurryStackIngredient> NESTED_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCreatorAccess.slurry().codecNonEmpty().fieldOf("ingredient").forGetter(ChemicalStackIngredient::ingredient), (App)SerializerHelper.POSITIVE_LONG_CODEC.fieldOf("amount").forGetter(ChemicalStackIngredient::amount)).apply((Applicative)instance, SlurryStackIngredient::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SlurryStackIngredient> STREAM_CODEC = StreamCodec.composite(IngredientCreatorAccess.slurry().streamCodec(), ChemicalStackIngredient::ingredient, (StreamCodec)ByteBufCodecs.VAR_LONG, ChemicalStackIngredient::amount, SlurryStackIngredient::new);

    public static SlurryStackIngredient of(ISlurryIngredient ingredient, long amount) {
        Objects.requireNonNull(ingredient, "SlurryStackIngredients cannot be created from a null ingredient.");
        if (ingredient.isEmpty()) {
            throw new IllegalArgumentException("SlurryStackIngredients cannot be created using the empty ingredient.");
        }
        return new SlurryStackIngredient(ingredient, amount);
    }

    private SlurryStackIngredient(ISlurryIngredient ingredient, long amount) {
        super(ingredient, amount);
    }
}

