/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.infuse.IEmptyInfusionProvider;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.chemical.IInfusionIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class InfusionStackIngredient
extends ChemicalStackIngredient<InfuseType, InfusionStack, IInfusionIngredient>
implements IEmptyInfusionProvider {
    public static final Codec<InfusionStackIngredient> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCreatorAccess.infusion().mapCodecNonEmpty().forGetter(ChemicalStackIngredient::ingredient), (App)SerializerHelper.POSITIVE_LONG_CODEC.fieldOf("amount").forGetter(ChemicalStackIngredient::amount)).apply((Applicative)instance, InfusionStackIngredient::new));
    public static final Codec<InfusionStackIngredient> NESTED_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCreatorAccess.infusion().codecNonEmpty().fieldOf("ingredient").forGetter(ChemicalStackIngredient::ingredient), (App)SerializerHelper.POSITIVE_LONG_CODEC.fieldOf("amount").forGetter(ChemicalStackIngredient::amount)).apply((Applicative)instance, InfusionStackIngredient::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, InfusionStackIngredient> STREAM_CODEC = StreamCodec.composite(IngredientCreatorAccess.infusion().streamCodec(), ChemicalStackIngredient::ingredient, (StreamCodec)ByteBufCodecs.VAR_LONG, ChemicalStackIngredient::amount, InfusionStackIngredient::new);

    public static InfusionStackIngredient of(IInfusionIngredient ingredient, long amount) {
        Objects.requireNonNull(ingredient, "InfusionStackIngredients cannot be created from a null ingredient.");
        if (ingredient.isEmpty()) {
            throw new IllegalArgumentException("InfusionStackIngredients cannot be created using the empty ingredient.");
        }
        return new InfusionStackIngredient(ingredient, amount);
    }

    private InfusionStackIngredient(IInfusionIngredient ingredient, long amount) {
        super(ingredient, amount);
    }
}

