/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IEmptyGasProvider;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.chemical.IGasIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class GasStackIngredient
extends ChemicalStackIngredient<Gas, GasStack, IGasIngredient>
implements IEmptyGasProvider {
    public static final Codec<GasStackIngredient> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCreatorAccess.gas().mapCodecNonEmpty().forGetter(ChemicalStackIngredient::ingredient), (App)SerializerHelper.POSITIVE_LONG_CODEC.fieldOf("amount").forGetter(ChemicalStackIngredient::amount)).apply((Applicative)instance, GasStackIngredient::new));
    public static final Codec<GasStackIngredient> NESTED_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCreatorAccess.gas().codecNonEmpty().fieldOf("ingredient").forGetter(ChemicalStackIngredient::ingredient), (App)SerializerHelper.POSITIVE_LONG_CODEC.fieldOf("amount").forGetter(ChemicalStackIngredient::amount)).apply((Applicative)instance, GasStackIngredient::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, GasStackIngredient> STREAM_CODEC = StreamCodec.composite(IngredientCreatorAccess.gas().streamCodec(), ChemicalStackIngredient::ingredient, (StreamCodec)ByteBufCodecs.VAR_LONG, ChemicalStackIngredient::amount, GasStackIngredient::new);

    public static GasStackIngredient of(IGasIngredient ingredient, long amount) {
        Objects.requireNonNull(ingredient, "GasStackIngredients cannot be created from a null ingredient.");
        if (ingredient.isEmpty()) {
            throw new IllegalArgumentException("GasStackIngredients cannot be created using the empty ingredient.");
        }
        return new GasStackIngredient(ingredient, amount);
    }

    private GasStackIngredient(IGasIngredient ingredient, long amount) {
        super(ingredient, amount);
    }
}

