/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients;

import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IEmptyStackProvider;
import mekanism.api.recipes.ingredients.GasStackIngredient;
import mekanism.api.recipes.ingredients.InfusionStackIngredient;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.ingredients.PigmentStackIngredient;
import mekanism.api.recipes.ingredients.SlurryStackIngredient;
import mekanism.api.recipes.ingredients.chemical.IChemicalIngredient;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public abstract sealed class ChemicalStackIngredient<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends IChemicalIngredient<CHEMICAL, INGREDIENT>>
implements InputIngredient<STACK>,
IEmptyStackProvider<CHEMICAL, STACK>
permits GasStackIngredient, InfusionStackIngredient, PigmentStackIngredient, SlurryStackIngredient {
    private final INGREDIENT ingredient;
    private final long amount;
    @Nullable
    private List<STACK> representations;

    protected ChemicalStackIngredient(INGREDIENT ingredient, long amount) {
        if (amount <= 0L) {
            throw new IllegalArgumentException("Size must be positive");
        }
        this.ingredient = ingredient;
        this.amount = amount;
    }

    @Override
    public boolean test(STACK stack) {
        return this.testType((CHEMICAL)stack) && ((ChemicalStack)stack).getAmount() >= this.amount;
    }

    @Override
    public boolean testType(STACK stack) {
        Objects.requireNonNull(stack);
        return this.testType((CHEMICAL)((ChemicalStack)stack).getChemical());
    }

    @Override
    public boolean testType(CHEMICAL chemical) {
        Objects.requireNonNull(chemical);
        return this.ingredient.test(chemical);
    }

    @Override
    public STACK getMatchingInstance(STACK stack) {
        return (STACK)(this.test(stack) ? ((ChemicalStack)stack).copyWithAmount(this.amount) : this.getEmptyStack());
    }

    @Override
    public long getNeededAmount(STACK stack) {
        return this.testType((CHEMICAL)stack) ? this.amount : 0L;
    }

    @Override
    public boolean hasNoMatchingInstances() {
        return this.ingredient.hasNoChemicals();
    }

    @Override
    public List<STACK> getRepresentations() {
        if (this.representations == null) {
            this.representations = this.ingredient.getChemicals().stream().map(s -> s.getStack(this.amount)).toList();
        }
        return this.representations;
    }

    public INGREDIENT ingredient() {
        return this.ingredient;
    }

    public long amount() {
        return this.amount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChemicalStackIngredient other = (ChemicalStackIngredient)o;
        return this.amount == other.amount && this.ingredient.equals(other.ingredient);
    }

    public int hashCode() {
        return Objects.hash(this.ingredient, this.amount);
    }

    public String toString() {
        return this.amount + "x " + String.valueOf(this.ingredient);
    }
}

