/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.chemical;

import java.util.List;
import java.util.function.BiPredicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.vanilla_input.SingleItemChemicalRecipeInput;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public abstract class ItemStackChemicalToItemStackRecipe<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK, ?>>
extends MekanismRecipe<SingleItemChemicalRecipeInput<CHEMICAL, STACK>>
implements BiPredicate<ItemStack, STACK> {
    public abstract ItemStackIngredient getItemInput();

    public abstract INGREDIENT getChemicalInput();

    @Contract(value="_, _ -> new", pure=true)
    public abstract ItemStack getOutput(ItemStack var1, STACK var2);

    @Override
    @NotNull
    public abstract ItemStack getResultItem(@NotNull HolderLookup.Provider var1);

    @Override
    public abstract boolean test(ItemStack var1, STACK var2);

    @Override
    @NotNull
    public ItemStack assemble(SingleItemChemicalRecipeInput<CHEMICAL, STACK> input, HolderLookup.Provider provider) {
        if (!this.isIncomplete() && this.test(input.item(), input.chemical())) {
            return this.getOutput(input.item(), input.chemical());
        }
        return ItemStack.EMPTY;
    }

    public boolean matches(SingleItemChemicalRecipeInput<CHEMICAL, STACK> input, Level level) {
        return !this.isIncomplete() && this.test(input.item(), input.chemical());
    }

    public abstract List<@NotNull ItemStack> getOutputDefinition();

    @Override
    public boolean isIncomplete() {
        return this.getItemInput().hasNoMatchingInstances() || ((ChemicalStackIngredient)this.getChemicalInput()).hasNoMatchingInstances();
    }
}

