/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.CachedRecipeHelper;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.GasStackIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class RotaryCachedRecipe
extends CachedRecipe<RotaryRecipe> {
    private final IOutputHandler<@NotNull GasStack> gasOutputHandler;
    private final IOutputHandler<@NotNull FluidStack> fluidOutputHandler;
    private final IInputHandler<@NotNull FluidStack> fluidInputHandler;
    private final IInputHandler<@NotNull GasStack> gasInputHandler;
    private final BooleanSupplier modeSupplier;
    private final Consumer<FluidStack> fluidInputSetter;
    private final Consumer<GasStack> gasInputSetter;
    private final Consumer<FluidStack> fluidOutputSetter;
    private final Consumer<GasStack> gasOutputSetter;
    private final Supplier<FluidStackIngredient> fluidInputGetter;
    private final Supplier<GasStackIngredient> gasInputGetter;
    private final Function<GasStack, FluidStack> fluidOutputGetter;
    private final Function<FluidStack, GasStack> gasOutputGetter;
    private FluidStack recipeFluid = FluidStack.EMPTY;
    private GasStack recipeGas = GasStack.EMPTY;
    private FluidStack fluidOutput = FluidStack.EMPTY;
    private GasStack gasOutput = GasStack.EMPTY;

    public RotaryCachedRecipe(RotaryRecipe recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NotNull FluidStack> fluidInputHandler, IInputHandler<@NotNull GasStack> gasInputHandler, IOutputHandler<@NotNull GasStack> gasOutputHandler, IOutputHandler<@NotNull FluidStack> fluidOutputHandler, BooleanSupplier modeSupplier) {
        super(recipe, recheckAllErrors);
        this.fluidInputHandler = Objects.requireNonNull(fluidInputHandler, "Fluid input handler cannot be null.");
        this.gasInputHandler = Objects.requireNonNull(gasInputHandler, "Gas input handler cannot be null.");
        this.gasOutputHandler = Objects.requireNonNull(gasOutputHandler, "Gas output handler cannot be null.");
        this.fluidOutputHandler = Objects.requireNonNull(fluidOutputHandler, "Fluid output handler cannot be null.");
        this.modeSupplier = Objects.requireNonNull(modeSupplier, "Mode supplier cannot be null.");
        this.fluidInputSetter = input -> {
            this.recipeFluid = input;
        };
        this.gasInputSetter = input -> {
            this.recipeGas = input;
        };
        this.fluidOutputSetter = output -> {
            this.fluidOutput = output;
        };
        this.gasOutputSetter = output -> {
            this.gasOutput = output;
        };
        this.fluidInputGetter = ((RotaryRecipe)this.recipe)::getFluidInput;
        this.gasInputGetter = ((RotaryRecipe)this.recipe)::getGasInput;
        this.fluidOutputGetter = ((RotaryRecipe)this.recipe)::getFluidOutput;
        this.gasOutputGetter = ((RotaryRecipe)this.recipe)::getGasOutput;
    }

    @Override
    protected void calculateOperationsThisTick(CachedRecipe.OperationTracker tracker) {
        super.calculateOperationsThisTick(tracker);
        if (tracker.shouldContinueChecking()) {
            if (this.modeSupplier.getAsBoolean()) {
                if (!((RotaryRecipe)this.recipe).hasFluidToGas()) {
                    tracker.mismatchedRecipe();
                } else {
                    CachedRecipeHelper.oneInputCalculateOperationsThisTick(tracker, this.fluidInputHandler, this.fluidInputGetter, this.fluidInputSetter, this.gasOutputHandler, this.gasOutputGetter, this.gasOutputSetter, ConstantPredicates.FLUID_EMPTY);
                }
            } else if (!((RotaryRecipe)this.recipe).hasGasToFluid()) {
                tracker.mismatchedRecipe();
            } else {
                CachedRecipeHelper.oneInputCalculateOperationsThisTick(tracker, this.gasInputHandler, this.gasInputGetter, this.gasInputSetter, this.fluidOutputHandler, this.fluidOutputGetter, this.fluidOutputSetter, ConstantPredicates.chemicalEmpty());
            }
        }
    }

    @Override
    public boolean isInputValid() {
        if (this.modeSupplier.getAsBoolean()) {
            if (!((RotaryRecipe)this.recipe).hasFluidToGas()) {
                return false;
            }
            FluidStack fluidStack = this.fluidInputHandler.getInput();
            return !fluidStack.isEmpty() && ((RotaryRecipe)this.recipe).test(fluidStack);
        }
        if (!((RotaryRecipe)this.recipe).hasGasToFluid()) {
            return false;
        }
        GasStack gasStack = this.gasInputHandler.getInput();
        return !gasStack.isEmpty() && ((RotaryRecipe)this.recipe).test(gasStack);
    }

    @Override
    protected void finishProcessing(int operations) {
        if (this.modeSupplier.getAsBoolean()) {
            if (((RotaryRecipe)this.recipe).hasFluidToGas() && !this.recipeFluid.isEmpty() && !this.gasOutput.isEmpty()) {
                this.fluidInputHandler.use(this.recipeFluid, operations);
                this.gasOutputHandler.handleOutput(this.gasOutput, operations);
            }
        } else if (((RotaryRecipe)this.recipe).hasGasToFluid() && !this.recipeGas.isEmpty() && !this.fluidOutput.isEmpty()) {
            this.gasInputHandler.use(this.recipeGas, operations);
            this.fluidOutputHandler.handleOutput(this.fluidOutput, operations);
        }
    }
}

