/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.outputs.BoxedChemicalOutputHandler;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class ChemicalDissolutionCachedRecipe
extends CachedRecipe<ChemicalDissolutionRecipe> {
    private final BoxedChemicalOutputHandler outputHandler;
    private final IInputHandler<@NotNull ItemStack> itemInputHandler;
    private final ILongInputHandler<@NotNull GasStack> gasInputHandler;
    private final LongSupplier gasUsage;
    private long gasUsageMultiplier;
    private ItemStack recipeItem = ItemStack.EMPTY;
    private GasStack recipeGas = GasStack.EMPTY;
    private BoxedChemicalStack output = BoxedChemicalStack.EMPTY;

    public ChemicalDissolutionCachedRecipe(ChemicalDissolutionRecipe recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NotNull ItemStack> itemInputHandler, ILongInputHandler<@NotNull GasStack> gasInputHandler, LongSupplier gasUsage, BoxedChemicalOutputHandler outputHandler) {
        super(recipe, recheckAllErrors);
        this.itemInputHandler = Objects.requireNonNull(itemInputHandler, "Item input handler cannot be null.");
        this.gasInputHandler = Objects.requireNonNull(gasInputHandler, "Gas input handler cannot be null.");
        this.gasUsage = Objects.requireNonNull(gasUsage, "Gas usage cannot be null.");
        this.outputHandler = Objects.requireNonNull(outputHandler, "Input handler cannot be null.");
    }

    @Override
    protected void setupVariableValues() {
        this.gasUsageMultiplier = Math.max(this.gasUsage.getAsLong(), 0L);
    }

    @Override
    protected void calculateOperationsThisTick(CachedRecipe.OperationTracker tracker) {
        super.calculateOperationsThisTick(tracker);
        if (tracker.shouldContinueChecking()) {
            this.recipeItem = this.itemInputHandler.getRecipeInput(((ChemicalDissolutionRecipe)this.recipe).getItemInput());
            if (this.recipeItem.isEmpty()) {
                tracker.mismatchedRecipe();
            } else {
                this.recipeGas = this.gasInputHandler.getRecipeInput(((ChemicalDissolutionRecipe)this.recipe).getGasInput());
                if (this.recipeGas.isEmpty()) {
                    tracker.updateOperations(0);
                    if (!tracker.shouldContinueChecking()) {
                        return;
                    }
                }
                this.itemInputHandler.calculateOperationsCanSupport(tracker, this.recipeItem);
                if (!this.recipeGas.isEmpty() && tracker.shouldContinueChecking()) {
                    this.gasInputHandler.calculateOperationsCanSupport(tracker, this.recipeGas, this.gasUsageMultiplier);
                    if (tracker.shouldContinueChecking()) {
                        this.output = ((ChemicalDissolutionRecipe)this.recipe).getOutput(this.recipeItem, this.recipeGas);
                        this.outputHandler.calculateOperationsRoomFor(tracker, this.output);
                    }
                }
            }
        }
    }

    @Override
    public boolean isInputValid() {
        GasStack gasStack;
        ItemStack itemInput = this.itemInputHandler.getInput();
        if (!itemInput.isEmpty() && !(gasStack = (GasStack)this.gasInputHandler.getInput()).isEmpty() && ((ChemicalDissolutionRecipe)this.recipe).test(itemInput, gasStack)) {
            GasStack recipeGas = this.gasInputHandler.getRecipeInput(((ChemicalDissolutionRecipe)this.recipe).getGasInput());
            return !recipeGas.isEmpty() && gasStack.getAmount() >= recipeGas.getAmount();
        }
        return false;
    }

    @Override
    protected void useResources(int operations) {
        super.useResources(operations);
        if (this.gasUsageMultiplier <= 0L) {
            return;
        }
        if (this.recipeGas.isEmpty()) {
            return;
        }
        this.gasInputHandler.use(this.recipeGas, (long)operations * this.gasUsageMultiplier);
    }

    @Override
    protected void finishProcessing(int operations) {
        if (!(this.recipeItem.isEmpty() || this.recipeGas.isEmpty() || this.output.isEmpty())) {
            this.itemInputHandler.use(this.recipeItem, operations);
            if (this.gasUsageMultiplier > 0L) {
                this.gasInputHandler.use(this.recipeGas, (long)operations * this.gasUsageMultiplier);
            }
            this.outputHandler.handleOutput(this.output, operations);
        }
    }
}

