/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongConsumer;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.recipes.MekanismRecipe;

@NothingNullByDefault
public abstract class CachedRecipe<RECIPE extends MekanismRecipe<?>> {
    protected final RECIPE recipe;
    private Set<OperationTracker.RecipeError> errors = Collections.emptySet();
    private boolean pausedForErrors = false;
    private final BooleanSupplier recheckAllErrors;
    private BooleanSupplier canHolderFunction = ConstantPredicates.ALWAYS_TRUE;
    private BooleanConsumer setActive = active -> {};
    private IntSupplier requiredTicks = () -> 1;
    private Runnable onFinish = () -> {};
    private FloatingLongSupplier perTickEnergy = () -> FloatingLong.ZERO;
    private FloatingLongSupplier storedEnergy = () -> FloatingLong.ZERO;
    private FloatingLongConsumer useEnergy = energy -> {};
    private IntSupplier baselineMaxOperations = () -> 1;
    private Consumer<OperationTracker> postProcessOperations = tracker -> {};
    private Consumer<Set<OperationTracker.RecipeError>> onErrorsChange = errors -> {};
    private int operatingTicks;
    private IntConsumer operatingTicksChanged = ticks -> {};

    protected CachedRecipe(RECIPE recipe, BooleanSupplier recheckAllErrors) {
        this.recipe = (MekanismRecipe)Objects.requireNonNull(recipe, "Recipe cannot be null.");
        this.recheckAllErrors = Objects.requireNonNull(recheckAllErrors, "Recheck all errors supplier cannot be null.");
    }

    public CachedRecipe<RECIPE> setCanHolderFunction(BooleanSupplier canHolderFunction) {
        this.canHolderFunction = Objects.requireNonNull(canHolderFunction, "Can holder function cannot be null.");
        return this;
    }

    public CachedRecipe<RECIPE> setActive(BooleanConsumer setActive) {
        this.setActive = Objects.requireNonNull(setActive, "Set active consumer cannot be null.");
        return this;
    }

    public CachedRecipe<RECIPE> setEnergyRequirements(FloatingLongSupplier perTickEnergy, IEnergyContainer energyContainer) {
        this.perTickEnergy = Objects.requireNonNull(perTickEnergy, "The per tick energy cannot be null.");
        Objects.requireNonNull(energyContainer, "Energy container cannot be null.");
        this.storedEnergy = energyContainer::getEnergy;
        this.useEnergy = energy -> energyContainer.extract(energy, Action.EXECUTE, AutomationType.INTERNAL);
        return this;
    }

    public CachedRecipe<RECIPE> setRequiredTicks(IntSupplier requiredTicks) {
        this.requiredTicks = Objects.requireNonNull(requiredTicks, "Required ticks cannot be null.");
        return this;
    }

    public CachedRecipe<RECIPE> setOperatingTicksChanged(IntConsumer operatingTicksChanged) {
        this.operatingTicksChanged = Objects.requireNonNull(operatingTicksChanged, "Operating ticks changed handler cannot be null.");
        return this;
    }

    public CachedRecipe<RECIPE> setOnFinish(Runnable onFinish) {
        this.onFinish = Objects.requireNonNull(onFinish, "On finish handling cannot be null.");
        return this;
    }

    public CachedRecipe<RECIPE> setBaselineMaxOperations(IntSupplier baselineMaxOperations) {
        this.baselineMaxOperations = Objects.requireNonNull(baselineMaxOperations, "Baseline max operations cannot be null.");
        return this;
    }

    public CachedRecipe<RECIPE> setPostProcessOperations(Consumer<OperationTracker> postProcessOperations) {
        this.postProcessOperations = Objects.requireNonNull(postProcessOperations, "Post processing of the operation count cannot be null.");
        return this;
    }

    public CachedRecipe<RECIPE> setErrorsChanged(Consumer<Set<OperationTracker.RecipeError>> onErrorsChange) {
        this.onErrorsChange = Objects.requireNonNull(onErrorsChange, "On errors change consumer cannot be null.");
        return this;
    }

    private void updateErrors(Set<OperationTracker.RecipeError> errors) {
        if (!this.errors.equals(errors)) {
            this.errors = errors;
            this.pausedForErrors = this.errors.size() > 1 ? true : !this.errors.contains(OperationTracker.RecipeError.NOT_ENOUGH_ENERGY_REDUCED_RATE);
            this.onErrorsChange.accept(errors);
        }
    }

    public void unpauseErrors() {
        this.pausedForErrors = false;
    }

    public void loadSavedOperatingTicks(int operatingTicks) {
        if (operatingTicks > 0 && operatingTicks < this.requiredTicks.getAsInt()) {
            this.operatingTicks = operatingTicks;
        }
    }

    public void process() {
        int operations;
        if (this.pausedForErrors) {
            this.setActive.accept(false);
            return;
        }
        if (this.canHolderFunction.getAsBoolean()) {
            this.setupVariableValues();
            OperationTracker tracker = new OperationTracker(this.errors, this.recheckAllErrors.getAsBoolean(), this.baselineMaxOperations.getAsInt());
            this.calculateOperationsThisTick(tracker);
            if (tracker.shouldContinueChecking()) {
                this.postProcessOperations.accept(tracker);
                if (tracker.shouldContinueChecking() && tracker.capAtMaxForEnergy()) {
                    tracker.addError(OperationTracker.RecipeError.NOT_ENOUGH_ENERGY_REDUCED_RATE);
                }
            }
            operations = tracker.currentMax;
            if (tracker.hasErrorsToCopy()) {
                this.updateErrors(tracker.errors);
            }
        } else {
            operations = 0;
            if (!this.errors.isEmpty()) {
                this.updateErrors(Collections.emptySet());
            }
        }
        if (operations > 0) {
            this.setActive.accept(true);
            this.useEnergy(operations);
            ++this.operatingTicks;
            int ticksRequired = this.requiredTicks.getAsInt();
            if (this.operatingTicks >= ticksRequired) {
                this.operatingTicks = 0;
                this.finishProcessing(operations);
                this.onFinish.run();
                this.resetCache();
            } else {
                this.useResources(operations);
            }
            if (ticksRequired > 1) {
                this.operatingTicksChanged.accept(this.operatingTicks);
            }
        } else {
            this.setActive.accept(false);
            if (operations < 0) {
                this.operatingTicks = 0;
                this.operatingTicksChanged.accept(this.operatingTicks);
                this.resetCache();
            }
        }
    }

    protected void setupVariableValues() {
    }

    protected int getOperatingTicks() {
        return this.operatingTicks;
    }

    protected void useResources(int operations) {
    }

    protected void resetCache() {
    }

    protected void useEnergy(int operations) {
        FloatingLong energy = this.perTickEnergy.get();
        if (operations == 1) {
            this.useEnergy.accept(energy);
        } else {
            this.useEnergy.accept(energy.multiply(operations));
        }
    }

    protected void calculateOperationsThisTick(OperationTracker tracker) {
        FloatingLong energyPerTick;
        if (tracker.shouldContinueChecking() && !(energyPerTick = this.perTickEnergy.get()).isZero()) {
            int operations;
            tracker.maxForEnergy = operations = this.storedEnergy.get().divideToInt(energyPerTick);
            if (operations == 0) {
                tracker.updateOperations(operations);
                tracker.addError(OperationTracker.RecipeError.NOT_ENOUGH_ENERGY);
            }
        }
    }

    public abstract boolean isInputValid();

    protected abstract void finishProcessing(int var1);

    public RECIPE getRecipe() {
        return this.recipe;
    }

    public static final class OperationTracker {
        private static final int RESET_PROGRESS = -1;
        private static final int MISMATCHED_RECIPE = -2;
        private final Set<RecipeError> lastErrors;
        private Set<RecipeError> errors = Collections.emptySet();
        private boolean checkAll;
        private boolean checkedErrors = true;
        private int currentMax;
        private int maxForEnergy;

        private OperationTracker(Set<RecipeError> lastErrors, boolean checkAll, int startingMax) {
            this.lastErrors = lastErrors;
            this.checkAll = checkAll;
            this.maxForEnergy = this.currentMax = startingMax;
        }

        private boolean hasErrorsToCopy() {
            if (this.currentMax == -2) {
                this.errors = Collections.emptySet();
                return true;
            }
            if (this.checkAll || this.currentMax > 0) {
                return true;
            }
            return !this.checkedErrors && !this.lastErrors.containsAll(this.errors);
        }

        public boolean shouldContinueChecking() {
            if (this.currentMax > 0) {
                return true;
            }
            if (this.currentMax == 0) {
                if (this.checkAll) {
                    return true;
                }
                if (!this.checkedErrors) {
                    if (!this.lastErrors.containsAll(this.errors)) {
                        this.checkAll = true;
                        return true;
                    }
                    this.checkedErrors = true;
                }
            }
            return false;
        }

        public boolean updateOperations(int max) {
            if (max < this.currentMax) {
                this.currentMax = max;
                return true;
            }
            return false;
        }

        private boolean capAtMaxForEnergy() {
            return this.updateOperations(this.maxForEnergy);
        }

        public void mismatchedRecipe() {
            this.updateOperations(-2);
        }

        public void resetProgress(RecipeError error) {
            this.updateOperations(-1);
            this.addError(error);
        }

        public void addError(RecipeError error) {
            Objects.requireNonNull(error, "Error cannot be null.");
            if (this.errors.isEmpty()) {
                this.errors = new ObjectArraySet();
            }
            if (this.errors.add(error)) {
                this.checkedErrors = false;
            }
        }

        public static final class RecipeError {
            public static final RecipeError INPUT_DOESNT_PRODUCE_OUTPUT = RecipeError.create();
            public static final RecipeError NOT_ENOUGH_ENERGY = RecipeError.create();
            public static final RecipeError NOT_ENOUGH_ENERGY_REDUCED_RATE = RecipeError.create();
            public static final RecipeError NOT_ENOUGH_INPUT = RecipeError.create();
            public static final RecipeError NOT_ENOUGH_SECONDARY_INPUT = RecipeError.create();
            public static final RecipeError NOT_ENOUGH_LEFT_INPUT = RecipeError.create();
            public static final RecipeError NOT_ENOUGH_RIGHT_INPUT = RecipeError.create();
            public static final RecipeError NOT_ENOUGH_OUTPUT_SPACE = RecipeError.create();

            public static RecipeError create() {
                return new RecipeError();
            }

            private RecipeError() {
            }
        }
    }
}

