/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.basic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.MekanismRecipeSerializers;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.GasStackIngredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class BasicRotaryRecipe
extends RotaryRecipe {
    protected final GasStackIngredient gasInput;
    protected final FluidStackIngredient fluidInput;
    protected final FluidStack fluidOutput;
    protected final GasStack gasOutput;
    protected final boolean hasGasToFluid;
    protected final boolean hasFluidToGas;

    public BasicRotaryRecipe(FluidStackIngredient fluidInput, GasStack gasOutput) {
        this.fluidInput = Objects.requireNonNull(fluidInput, "Fluid input cannot be null.");
        Objects.requireNonNull(gasOutput, "Gas output cannot be null.");
        if (gasOutput.isEmpty()) {
            throw new IllegalArgumentException("Gas output cannot be empty.");
        }
        this.gasOutput = gasOutput.copy();
        this.gasInput = null;
        this.fluidOutput = FluidStack.EMPTY;
        this.hasGasToFluid = false;
        this.hasFluidToGas = true;
    }

    public BasicRotaryRecipe(GasStackIngredient gasInput, FluidStack fluidOutput) {
        this.gasInput = Objects.requireNonNull(gasInput, "Gas input cannot be null.");
        Objects.requireNonNull(fluidOutput, "Fluid output cannot be null.");
        if (fluidOutput.isEmpty()) {
            throw new IllegalArgumentException("Fluid output cannot be empty.");
        }
        this.fluidOutput = fluidOutput.copy();
        this.fluidInput = null;
        this.gasOutput = GasStack.EMPTY;
        this.hasGasToFluid = true;
        this.hasFluidToGas = false;
    }

    public BasicRotaryRecipe(FluidStackIngredient fluidInput, GasStackIngredient gasInput, GasStack gasOutput, FluidStack fluidOutput) {
        this.gasInput = Objects.requireNonNull(gasInput, "Gas input cannot be null.");
        this.fluidInput = Objects.requireNonNull(fluidInput, "Fluid input cannot be null.");
        Objects.requireNonNull(gasOutput, "Gas output cannot be null.");
        Objects.requireNonNull(fluidOutput, "Fluid output cannot be null.");
        if (gasOutput.isEmpty()) {
            throw new IllegalArgumentException("Gas output cannot be empty.");
        }
        if (fluidOutput.isEmpty()) {
            throw new IllegalArgumentException("Fluid output cannot be empty.");
        }
        this.gasOutput = gasOutput.copy();
        this.fluidOutput = fluidOutput.copy();
        this.hasGasToFluid = true;
        this.hasFluidToGas = true;
    }

    @Override
    public boolean hasGasToFluid() {
        return this.hasGasToFluid;
    }

    @Override
    public boolean hasFluidToGas() {
        return this.hasFluidToGas;
    }

    protected void assertHasGasToFluid() {
        if (!this.hasGasToFluid()) {
            throw new IllegalStateException("This recipe has no gas to fluid conversion.");
        }
    }

    protected void assertHasFluidToGas() {
        if (!this.hasFluidToGas()) {
            throw new IllegalStateException("This recipe has no fluid to gas conversion.");
        }
    }

    @Override
    public boolean test(FluidStack fluidStack) {
        return this.hasFluidToGas() && this.fluidInput.test(fluidStack);
    }

    @Override
    public boolean test(GasStack gasStack) {
        return this.hasGasToFluid() && this.gasInput.test(gasStack);
    }

    @Override
    public FluidStackIngredient getFluidInput() {
        this.assertHasFluidToGas();
        return this.fluidInput;
    }

    @Override
    public GasStackIngredient getGasInput() {
        this.assertHasGasToFluid();
        return this.gasInput;
    }

    @Override
    public List<GasStack> getGasOutputDefinition() {
        this.assertHasFluidToGas();
        return Collections.singletonList(this.gasOutput);
    }

    @Override
    public List<FluidStack> getFluidOutputDefinition() {
        this.assertHasGasToFluid();
        return Collections.singletonList(this.fluidOutput);
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    public GasStack getGasOutput(FluidStack input) {
        this.assertHasFluidToGas();
        return this.gasOutput.copy();
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    public FluidStack getFluidOutput(GasStack input) {
        this.assertHasGasToFluid();
        return this.fluidOutput.copy();
    }

    @Nullable
    public GasStackIngredient getGasInputRaw() {
        return this.gasInput;
    }

    public GasStack getGasOutputRaw() {
        return this.gasOutput;
    }

    @Nullable
    public FluidStackIngredient getFluidInputRaw() {
        return this.fluidInput;
    }

    public FluidStack getFluidOutputRaw() {
        return this.fluidOutput;
    }

    public RecipeSerializer<BasicRotaryRecipe> getSerializer() {
        return (RecipeSerializer)MekanismRecipeSerializers.ROTARY.get();
    }
}

