/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.basic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.MekanismRecipeSerializers;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.GasStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;

@NothingNullByDefault
public class BasicPressurizedReactionRecipe
extends PressurizedReactionRecipe {
    protected final ItemStackIngredient inputSolid;
    protected final FluidStackIngredient inputFluid;
    protected final GasStackIngredient inputGas;
    protected final FloatingLong energyRequired;
    protected final int duration;
    protected final ItemStack outputItem;
    protected final GasStack outputGas;

    public BasicPressurizedReactionRecipe(ItemStackIngredient inputSolid, FluidStackIngredient inputFluid, GasStackIngredient inputGas, FloatingLong energyRequired, int duration, ItemStack outputItem, GasStack outputGas) {
        this.inputSolid = Objects.requireNonNull(inputSolid, "Item input cannot be null.");
        this.inputFluid = Objects.requireNonNull(inputFluid, "Fluid input cannot be null.");
        this.inputGas = Objects.requireNonNull(inputGas, "Gas input cannot be null.");
        this.energyRequired = Objects.requireNonNull(energyRequired, "Required energy cannot be null.").copyAsConst();
        if (duration <= 0) {
            throw new IllegalArgumentException("Duration must be positive.");
        }
        this.duration = duration;
        Objects.requireNonNull(outputItem, "Item output cannot be null.");
        Objects.requireNonNull(outputGas, "Gas output cannot be null.");
        if (outputItem.isEmpty() && outputGas.isEmpty()) {
            throw new IllegalArgumentException("At least one output must not be empty.");
        }
        this.outputItem = outputItem.copy();
        this.outputGas = outputGas.copy();
    }

    @Override
    public ItemStackIngredient getInputSolid() {
        return this.inputSolid;
    }

    @Override
    public FluidStackIngredient getInputFluid() {
        return this.inputFluid;
    }

    @Override
    public GasStackIngredient getInputGas() {
        return this.inputGas;
    }

    @Override
    public FloatingLong getEnergyRequired() {
        return this.energyRequired;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public boolean test(ItemStack solid, FluidStack liquid, GasStack gas) {
        return this.inputSolid.test(solid) && this.inputFluid.test(liquid) && this.inputGas.test(gas);
    }

    @Override
    public List<PressurizedReactionRecipe.PressurizedReactionRecipeOutput> getOutputDefinition() {
        return Collections.singletonList(new PressurizedReactionRecipe.PressurizedReactionRecipeOutput(this.outputItem, this.outputGas));
    }

    @Override
    @Contract(value="_, _, _ -> new", pure=true)
    public PressurizedReactionRecipe.PressurizedReactionRecipeOutput getOutput(ItemStack solid, FluidStack liquid, GasStack gas) {
        return new PressurizedReactionRecipe.PressurizedReactionRecipeOutput(this.outputItem.copy(), this.outputGas.copy());
    }

    public ItemStack getOutputItem() {
        return this.outputItem;
    }

    public GasStack getOutputGas() {
        return this.outputGas;
    }

    public RecipeSerializer<BasicPressurizedReactionRecipe> getSerializer() {
        return (RecipeSerializer)MekanismRecipeSerializers.REACTION.get();
    }
}

