/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes;

import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.MekanismRecipeTypes;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.GasStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.vanilla_input.ReactionRecipeInput;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.TriPredicate;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public abstract class PressurizedReactionRecipe
extends MekanismRecipe<ReactionRecipeInput>
implements TriPredicate<ItemStack, FluidStack, GasStack> {
    private static final Holder<Item> PRESSURIZED_REACTION_CHAMBER = DeferredHolder.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)"pressurized_reaction_chamber"));

    public abstract ItemStackIngredient getInputSolid();

    public abstract FluidStackIngredient getInputFluid();

    public abstract GasStackIngredient getInputGas();

    public abstract FloatingLong getEnergyRequired();

    public abstract int getDuration();

    public abstract boolean test(ItemStack var1, FluidStack var2, GasStack var3);

    public boolean matches(ReactionRecipeInput input, Level level) {
        return !this.isIncomplete() && this.test(input.item(), input.fluid(), input.gas());
    }

    public abstract List<PressurizedReactionRecipeOutput> getOutputDefinition();

    @Contract(value="_, _, _ -> new", pure=true)
    public abstract PressurizedReactionRecipeOutput getOutput(ItemStack var1, FluidStack var2, GasStack var3);

    @Override
    public boolean isIncomplete() {
        return this.getInputSolid().hasNoMatchingInstances() || this.getInputFluid().hasNoMatchingInstances() || this.getInputGas().hasNoMatchingInstances();
    }

    public final RecipeType<?> getType() {
        return (RecipeType)MekanismRecipeTypes.TYPE_REACTION.value();
    }

    public String getGroup() {
        return "pressurized_reaction_chamber";
    }

    public ItemStack getToastSymbol() {
        return new ItemStack(PRESSURIZED_REACTION_CHAMBER);
    }

    public record PressurizedReactionRecipeOutput(@NotNull ItemStack item, @NotNull GasStack gas) {
        public PressurizedReactionRecipeOutput(@NotNull ItemStack item, @NotNull GasStack gas) {
            Objects.requireNonNull(item, "Item output cannot be null.");
            Objects.requireNonNull(gas, "Gas output cannot be null.");
            if (item.isEmpty() && gas.isEmpty()) {
                throw new IllegalArgumentException("At least one output must be present.");
            }
        }
    }
}

