/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.math;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.container.ContainerInteraction;
import mekanism.api.container.InContainerGetter;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class FloatingLongTransferUtils {
    private FloatingLongTransferUtils() {
    }

    public static FloatingLong insert(FloatingLong stack, @Nullable Direction side, Action action, ToIntFunction<@Nullable Direction> containerCount, InContainerGetter<FloatingLong> inContainerGetter, ContainerInteraction<FloatingLong> insert) {
        FloatingLong remainder;
        if (stack.isZero()) {
            return FloatingLong.ZERO;
        }
        int containers = containerCount.applyAsInt(side);
        if (containers == 0) {
            return stack;
        }
        if (containers == 1) {
            return insert.interact(0, stack, side, action);
        }
        FloatingLong toInsert = stack;
        IntArrayList emptyContainers = new IntArrayList();
        for (int container = 0; container < containers; ++container) {
            FloatingLong inContainer = inContainerGetter.getStored(container, side);
            if (inContainer.isZero()) {
                emptyContainers.add(container);
                continue;
            }
            remainder = insert.interact(container, toInsert, side, action);
            if (remainder.isZero()) {
                return FloatingLong.ZERO;
            }
            toInsert = remainder;
        }
        IntListIterator intListIterator = emptyContainers.iterator();
        while (intListIterator.hasNext()) {
            int container = (Integer)intListIterator.next();
            remainder = insert.interact(container, toInsert, side, action);
            if (remainder.isZero()) {
                return FloatingLong.ZERO;
            }
            toInsert = remainder;
        }
        return toInsert;
    }

    public static FloatingLong insert(FloatingLong stack, @Nullable Direction side, Function<@Nullable Direction, List<IEnergyContainer>> energyContainerSupplier, Action action, AutomationType automationType) {
        if (stack.isZero()) {
            return FloatingLong.ZERO;
        }
        List<IEnergyContainer> energyContainers = energyContainerSupplier.apply(side);
        return FloatingLongTransferUtils.insert(stack, action, automationType, energyContainers.size(), energyContainers);
    }

    public static FloatingLong insert(FloatingLong stack, Action action, AutomationType automationType, int size, Iterable<IEnergyContainer> energyContainers) {
        if (stack.isZero()) {
            return FloatingLong.ZERO;
        }
        if (size == 0) {
            return stack;
        }
        if (size == 1) {
            return energyContainers.iterator().next().insert(stack, action, automationType);
        }
        FloatingLong toInsert = stack;
        ArrayList<IEnergyContainer> emptyContainers = new ArrayList<IEnergyContainer>();
        for (IEnergyContainer energyContainer : energyContainers) {
            FloatingLong inContainer = energyContainer.getEnergy();
            if (inContainer.isZero()) {
                emptyContainers.add(energyContainer);
                continue;
            }
            FloatingLong remainder = energyContainer.insert(toInsert, action, automationType);
            if (remainder.isZero()) {
                return FloatingLong.ZERO;
            }
            toInsert = remainder;
        }
        for (IEnergyContainer container : emptyContainers) {
            FloatingLong remainder = container.insert(toInsert, action, automationType);
            if (remainder.isZero()) {
                return FloatingLong.ZERO;
            }
            toInsert = remainder;
        }
        return toInsert;
    }

    public static FloatingLong extract(FloatingLong amount, @Nullable Direction side, Action action, ToIntFunction<@Nullable Direction> containerCount, ContainerInteraction<FloatingLong> extract) {
        if (amount.isZero()) {
            return FloatingLong.ZERO;
        }
        int containers = containerCount.applyAsInt(side);
        if (containers == 0) {
            return FloatingLong.ZERO;
        }
        if (containers == 1) {
            return extract.interact(0, amount, side, action);
        }
        FloatingLong extracted = FloatingLong.ZERO;
        FloatingLong toExtract = amount.copy();
        for (int container = 0; container < containers; ++container) {
            FloatingLong drained = extract.interact(container, toExtract, side, action);
            if (drained.isZero()) continue;
            extracted = extracted.isZero() ? drained : extracted.plusEqual(drained);
            if ((toExtract = toExtract.minusEqual(drained)).isZero()) break;
        }
        return extracted;
    }

    public static FloatingLong extract(FloatingLong amount, @Nullable Direction side, Function<@Nullable Direction, List<IEnergyContainer>> energyContainerSupplier, Action action, AutomationType automationType) {
        if (amount.isZero()) {
            return FloatingLong.ZERO;
        }
        List<IEnergyContainer> energyContainers = energyContainerSupplier.apply(side);
        return FloatingLongTransferUtils.extract(amount, action, automationType, energyContainers.size(), energyContainers);
    }

    public static FloatingLong extract(FloatingLong amount, Action action, AutomationType automationType, int size, Iterable<IEnergyContainer> energyContainers) {
        if (amount.isZero() || size == 0) {
            return FloatingLong.ZERO;
        }
        if (size == 1) {
            return energyContainers.iterator().next().extract(amount, action, automationType);
        }
        FloatingLong extracted = FloatingLong.ZERO;
        FloatingLong toExtract = amount.copy();
        for (IEnergyContainer energyContainer : energyContainers) {
            FloatingLong drained = energyContainer.extract(toExtract, action, automationType);
            if (drained.isZero()) continue;
            extracted = extracted.isZero() ? drained : extracted.plusEqual(drained);
            if (!(toExtract = toExtract.minusEqual(drained)).isZero()) continue;
            break;
        }
        return extracted;
    }
}

