/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.heat;

import java.util.List;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.ISidedHeatHandler;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface IMekanismHeatHandler
extends ISidedHeatHandler,
IContentsListener {
    default public boolean canHandleHeat() {
        return true;
    }

    @Override
    default public int getHeatCapacitorCount(@Nullable Direction side) {
        return this.getHeatCapacitors(side).size();
    }

    public List<IHeatCapacitor> getHeatCapacitors(@Nullable Direction var1);

    @Nullable
    default public IHeatCapacitor getHeatCapacitor(int capacitor, @Nullable Direction side) {
        List<IHeatCapacitor> capacitors = this.getHeatCapacitors(side);
        return capacitor >= 0 && capacitor < capacitors.size() ? capacitors.get(capacitor) : null;
    }

    @Override
    default public double getTemperature(int capacitor, @Nullable Direction side) {
        IHeatCapacitor heatCapacitor = this.getHeatCapacitor(capacitor, side);
        return heatCapacitor == null ? 300.0 : heatCapacitor.getTemperature();
    }

    @Override
    default public double getInverseConduction(int capacitor, @Nullable Direction side) {
        IHeatCapacitor heatCapacitor = this.getHeatCapacitor(capacitor, side);
        return heatCapacitor == null ? 1.0 : heatCapacitor.getInverseConduction();
    }

    @Override
    default public double getHeatCapacity(int capacitor, @Nullable Direction side) {
        IHeatCapacitor heatCapacitor = this.getHeatCapacitor(capacitor, side);
        return heatCapacitor == null ? 1.0 : heatCapacitor.getHeatCapacity();
    }

    @Override
    default public void handleHeat(int capacitor, double transfer, @Nullable Direction side) {
        IHeatCapacitor heatCapacitor = this.getHeatCapacitor(capacitor, side);
        if (heatCapacitor != null) {
            heatCapacitor.handleHeat(transfer);
        }
    }

    default public double getInverseInsulation(int capacitor, @Nullable Direction side) {
        IHeatCapacitor heatCapacitor = this.getHeatCapacitor(capacitor, side);
        return heatCapacitor == null ? 0.0 : heatCapacitor.getInverseInsulation();
    }

    default public double getTotalInverseInsulation(@Nullable Direction side) {
        List<IHeatCapacitor> heatCapacitors = this.getHeatCapacitors(side);
        if (heatCapacitors.isEmpty()) {
            return 0.0;
        }
        if (heatCapacitors.size() == 1) {
            return heatCapacitors.getFirst().getInverseInsulation();
        }
        double sum = 0.0;
        double totalCapacity = this.getTotalHeatCapacity(heatCapacitors);
        for (IHeatCapacitor capacitor : heatCapacitors) {
            sum += capacitor.getInverseInsulation() * (capacitor.getHeatCapacity() / totalCapacity);
        }
        return sum;
    }

    @Override
    default public double getTotalTemperature(@Nullable Direction side) {
        List<IHeatCapacitor> heatCapacitors = this.getHeatCapacitors(side);
        if (heatCapacitors.isEmpty()) {
            return 0.0;
        }
        if (heatCapacitors.size() == 1) {
            return heatCapacitors.getFirst().getTemperature();
        }
        double sum = 0.0;
        double totalCapacity = this.getTotalHeatCapacity(heatCapacitors);
        for (IHeatCapacitor capacitor : heatCapacitors) {
            sum += capacitor.getTemperature() * (capacitor.getHeatCapacity() / totalCapacity);
        }
        return sum;
    }

    @Override
    default public double getTotalInverseConductionCoefficient(@Nullable Direction side) {
        List<IHeatCapacitor> heatCapacitors = this.getHeatCapacitors(side);
        if (heatCapacitors.isEmpty()) {
            return 1.0;
        }
        if (heatCapacitors.size() == 1) {
            return heatCapacitors.getFirst().getInverseConduction();
        }
        double sum = 0.0;
        double totalCapacity = this.getTotalHeatCapacity(heatCapacitors);
        for (IHeatCapacitor capacitor : heatCapacitors) {
            sum += capacitor.getInverseConduction() * (capacitor.getHeatCapacity() / totalCapacity);
        }
        return sum;
    }

    @Override
    default public double getTotalHeatCapacity(@Nullable Direction side) {
        return this.getTotalHeatCapacity(this.getHeatCapacitors(side));
    }

    private double getTotalHeatCapacity(List<IHeatCapacitor> capacitors) {
        if (capacitors.size() == 1) {
            return capacitors.getFirst().getHeatCapacity();
        }
        double sum = 0.0;
        for (IHeatCapacitor capacitor : capacitors) {
            sum += capacitor.getHeatCapacity();
        }
        return sum;
    }

    @Override
    default public void handleHeat(double transfer, @Nullable Direction side) {
        List<IHeatCapacitor> heatCapacitors = this.getHeatCapacitors(side);
        if (heatCapacitors.size() == 1) {
            heatCapacitors.getFirst().handleHeat(transfer);
        } else if (!heatCapacitors.isEmpty()) {
            double totalHeatCapacity = this.getTotalHeatCapacity(heatCapacitors);
            for (IHeatCapacitor heatCapacitor : heatCapacitors) {
                heatCapacitor.handleHeat(transfer * (heatCapacitor.getHeatCapacity() / totalHeatCapacity));
            }
        }
    }
}

