/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.gear.config.ModuleConfig;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

@NothingNullByDefault
public class ModuleBooleanConfig
extends ModuleConfig<Boolean> {
    public static final Codec<ModuleBooleanConfig> CODEC = RecordCodecBuilder.create(instance -> ModuleBooleanConfig.baseCodec(instance).and((App)Codec.BOOL.fieldOf("value").forGetter(ModuleConfig::get)).apply((Applicative)instance, ModuleBooleanConfig::new));
    public static final StreamCodec<ByteBuf, ModuleBooleanConfig> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ModuleConfig::name, (StreamCodec)ByteBufCodecs.BOOL, ModuleConfig::get, ModuleBooleanConfig::new);
    private final boolean value;

    public static ModuleBooleanConfig create(ResourceLocation name, boolean value) {
        return new ModuleBooleanConfig(name, value);
    }

    protected ModuleBooleanConfig(ResourceLocation name, boolean value) {
        super(name);
        this.value = value;
    }

    @Override
    public StreamCodec<ByteBuf, ModuleConfig<Boolean>> namedStreamCodec(ResourceLocation name) {
        return ByteBufCodecs.BOOL.map(val -> new ModuleBooleanConfig(name, (boolean)val), ModuleConfig::get);
    }

    @Override
    public Boolean get() {
        return this.value;
    }

    public ModuleBooleanConfig with(Boolean value) {
        Objects.requireNonNull(value, "Value cannot be null.");
        return this.value == value ? this : new ModuleBooleanConfig(this.name(), value);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.value == ((ModuleBooleanConfig)o).value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }
}

