/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IHUDElement;
import mekanism.api.gear.IModule;
import mekanism.api.gear.ModuleData;
import mekanism.api.gear.config.ModuleConfig;
import mekanism.api.providers.IModuleDataProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface IModuleContainer {
    public Map<ModuleData<?>, ? extends IModule<?>> typedModules();

    public Collection<? extends IModule<?>> modules();

    default public Set<ModuleData<?>> moduleTypes() {
        return this.typedModules().keySet();
    }

    public <MODULE extends ICustomModule<MODULE>> IModuleContainer replaceModuleConfig(HolderLookup.Provider var1, ItemStack var2, IModuleDataProvider<MODULE> var3, ModuleConfig<?> var4);

    public ItemEnchantments moduleBasedEnchantments();

    default public int getModuleEnchantmentLevel(Holder<Enchantment> enchantment) {
        return this.moduleBasedEnchantments().getLevel(enchantment);
    }

    default public int installedCount() {
        return this.typedModules().size();
    }

    default public int installedCount(IModuleDataProvider<?> typeProvider) {
        IModule<?> module = this.get(typeProvider);
        return module == null ? 0 : module.getInstalledCount();
    }

    @Nullable
    public <MODULE extends ICustomModule<MODULE>> IModule<MODULE> get(IModuleDataProvider<MODULE> var1);

    @Nullable
    default public <MODULE extends ICustomModule<MODULE>> IModule<MODULE> getIfEnabled(IModuleDataProvider<MODULE> typeProvider) {
        IModule<MODULE> module = this.get(typeProvider);
        return module != null && module.isEnabled() ? module : null;
    }

    default public boolean has(IModuleDataProvider<?> typeProvider) {
        return this.typedModules().containsKey(typeProvider.getModuleData());
    }

    default public boolean hasEnabled(IModuleDataProvider<?> typeProvider) {
        return this.getIfEnabled(typeProvider) != null;
    }

    public List<IHUDElement> getHUDElements(Player var1, ItemStack var2);

    public List<Component> getHUDStrings(Player var1, ItemStack var2);
}

