/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.fluid;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

@NothingNullByDefault
public interface IExtendedFluidTank
extends IFluidTank,
INBTSerializable<CompoundTag>,
IContentsListener {
    public void setStack(FluidStack var1);

    public void setStackUnchecked(FluidStack var1);

    default public FluidStack insert(FluidStack stack, Action action, AutomationType automationType) {
        if (stack.isEmpty() || !this.isFluidValid(stack)) {
            return stack;
        }
        int needed = this.getNeeded();
        if (needed <= 0) {
            return stack;
        }
        boolean sameType = false;
        if (this.isEmpty() || (sameType = FluidStack.isSameFluidSameComponents((FluidStack)stack, (FluidStack)this.getFluid()))) {
            int toAdd = Math.min(stack.getAmount(), needed);
            if (action.execute()) {
                if (sameType) {
                    this.growStack(toAdd, action);
                } else {
                    this.setStack(stack.copyWithAmount(toAdd));
                }
            }
            return stack.copyWithAmount(stack.getAmount() - toAdd);
        }
        return stack;
    }

    default public FluidStack extract(int amount, Action action, AutomationType automationType) {
        if (this.isEmpty() || amount < 1) {
            return FluidStack.EMPTY;
        }
        FluidStack ret = this.getFluid().copyWithAmount(Math.min(this.getFluidAmount(), amount));
        if (!ret.isEmpty() && action.execute()) {
            this.shrinkStack(ret.getAmount(), action);
        }
        return ret;
    }

    default public int setStackSize(int amount, Action action) {
        if (this.isEmpty()) {
            return 0;
        }
        if (amount <= 0) {
            if (action.execute()) {
                this.setEmpty();
            }
            return 0;
        }
        int maxStackSize = this.getCapacity();
        if (amount > maxStackSize) {
            amount = maxStackSize;
        }
        if (this.getFluidAmount() == amount || action.simulate()) {
            return amount;
        }
        this.setStack(this.getFluid().copyWithAmount(amount));
        return amount;
    }

    default public int growStack(int amount, Action action) {
        int current = this.getFluidAmount();
        if (current == 0) {
            return 0;
        }
        if (amount > 0) {
            amount = Math.min(amount, this.getNeeded());
        }
        int newSize = this.setStackSize(current + amount, action);
        return newSize - current;
    }

    default public int shrinkStack(int amount, Action action) {
        return -this.growStack(-amount, action);
    }

    default public boolean isEmpty() {
        return this.getFluid().isEmpty();
    }

    default public void setEmpty() {
        this.setStack(FluidStack.EMPTY);
    }

    default public boolean isFluidEqual(FluidStack other) {
        return FluidStack.isSameFluidSameComponents((FluidStack)this.getFluid(), (FluidStack)other);
    }

    default public int getNeeded() {
        return Math.max(0, this.getCapacity() - this.getFluidAmount());
    }

    default public int getFluidAmount() {
        return this.getFluid().getAmount();
    }

    default public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        if (!this.isEmpty()) {
            nbt.put("stored", this.getFluid().save(provider));
        }
        return nbt;
    }

    @Deprecated
    default public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
        return stack.getAmount() - this.insert(stack, Action.fromFluidAction(action), AutomationType.EXTERNAL).getAmount();
    }

    @Deprecated
    default public FluidStack drain(FluidStack stack, IFluidHandler.FluidAction action) {
        if (!this.isEmpty() && this.isFluidEqual(stack)) {
            return this.extract(stack.getAmount(), Action.fromFluidAction(action), AutomationType.EXTERNAL);
        }
        return FluidStack.EMPTY;
    }

    @Deprecated
    default public FluidStack drain(int amount, IFluidHandler.FluidAction action) {
        return this.extract(amount, Action.fromFluidAction(action), AutomationType.EXTERNAL);
    }
}

