/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.energy;

import java.util.List;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.energy.ISidedStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongTransferUtils;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface IMekanismStrictEnergyHandler
extends ISidedStrictEnergyHandler,
IContentsListener {
    default public boolean canHandleEnergy() {
        return true;
    }

    public List<IEnergyContainer> getEnergyContainers(@Nullable Direction var1);

    @Nullable
    default public IEnergyContainer getEnergyContainer(int container, @Nullable Direction side) {
        List<IEnergyContainer> containers = this.getEnergyContainers(side);
        return container >= 0 && container < containers.size() ? containers.get(container) : null;
    }

    @Override
    default public int getEnergyContainerCount(@Nullable Direction side) {
        return this.getEnergyContainers(side).size();
    }

    @Override
    default public FloatingLong getEnergy(int container, @Nullable Direction side) {
        IEnergyContainer energyContainer = this.getEnergyContainer(container, side);
        return energyContainer == null ? FloatingLong.ZERO : energyContainer.getEnergy();
    }

    @Override
    default public void setEnergy(int container, FloatingLong energy, @Nullable Direction side) {
        IEnergyContainer energyContainer = this.getEnergyContainer(container, side);
        if (energyContainer != null) {
            energyContainer.setEnergy(energy);
        }
    }

    @Override
    default public FloatingLong getMaxEnergy(int container, @Nullable Direction side) {
        IEnergyContainer energyContainer = this.getEnergyContainer(container, side);
        return energyContainer == null ? FloatingLong.ZERO : energyContainer.getMaxEnergy();
    }

    @Override
    default public FloatingLong getNeededEnergy(int container, @Nullable Direction side) {
        IEnergyContainer energyContainer = this.getEnergyContainer(container, side);
        return energyContainer == null ? FloatingLong.ZERO : energyContainer.getNeeded();
    }

    @Override
    default public FloatingLong insertEnergy(int container, FloatingLong amount, @Nullable Direction side, Action action) {
        IEnergyContainer energyContainer = this.getEnergyContainer(container, side);
        return energyContainer == null ? amount : energyContainer.insert(amount, action, AutomationType.handler(side));
    }

    @Override
    default public FloatingLong extractEnergy(int container, FloatingLong amount, @Nullable Direction side, Action action) {
        IEnergyContainer energyContainer = this.getEnergyContainer(container, side);
        return energyContainer == null ? FloatingLong.ZERO : energyContainer.extract(amount, action, AutomationType.handler(side));
    }

    @Override
    default public FloatingLong insertEnergy(FloatingLong amount, @Nullable Direction side, Action action) {
        return FloatingLongTransferUtils.insert(amount, side, this::getEnergyContainers, action, AutomationType.handler(side));
    }

    @Override
    default public FloatingLong extractEnergy(FloatingLong amount, @Nullable Direction side, Action action) {
        return FloatingLongTransferUtils.extract(amount, side, this::getEnergyContainers, action, AutomationType.handler(side));
    }
}

