/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.energy;

import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.FloatingLong;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.common.util.INBTSerializable;

@NothingNullByDefault
public interface IEnergyContainer
extends INBTSerializable<CompoundTag>,
IContentsListener {
    public FloatingLong getEnergy();

    public void setEnergy(FloatingLong var1);

    default public FloatingLong insert(FloatingLong amount, Action action, AutomationType automationType) {
        if (amount.isZero()) {
            return amount;
        }
        FloatingLong needed = this.getNeeded();
        if (needed.isZero()) {
            return amount;
        }
        FloatingLong toAdd = amount.min(needed);
        if (!toAdd.isZero() && action.execute()) {
            this.setEnergy(this.getEnergy().add(toAdd));
        }
        return amount.subtract(toAdd);
    }

    default public FloatingLong extract(FloatingLong amount, Action action, AutomationType automationType) {
        if (this.isEmpty() || amount.isZero()) {
            return FloatingLong.ZERO;
        }
        FloatingLong ret = this.getEnergy().min(amount).copy();
        if (!ret.isZero() && action.execute()) {
            this.setEnergy(this.getEnergy().subtract(ret));
        }
        return ret;
    }

    public FloatingLong getMaxEnergy();

    default public boolean isEmpty() {
        return this.getEnergy().isZero();
    }

    default public void setEmpty() {
        this.setEnergy(FloatingLong.ZERO);
    }

    default public FloatingLong getNeeded() {
        return this.getMaxEnergy().subtract(this.getEnergy());
    }

    default public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        if (!this.isEmpty()) {
            nbt.putString("stored", this.getEnergy().toString());
        }
        return nbt;
    }
}

