/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.codec;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DependentMapCodec<ELEMENT, DEPENDENCY>
extends MapCodec<ELEMENT> {
    private final String fieldName;
    private final Function<DEPENDENCY, Codec<ELEMENT>> elementCodecGetter;
    private final MapCodec<DEPENDENCY> dependencyMapCodec;
    private final Function<ELEMENT, DEPENDENCY> dependencyGetter;

    public DependentMapCodec(String fieldName, Function<DEPENDENCY, Codec<ELEMENT>> elementCodecGetter, MapCodec<DEPENDENCY> dependencyMapCodec, Function<ELEMENT, DEPENDENCY> dependencyGetter) {
        this.fieldName = fieldName;
        this.elementCodecGetter = elementCodecGetter;
        this.dependencyMapCodec = dependencyMapCodec;
        this.dependencyGetter = dependencyGetter;
    }

    public <T> RecordBuilder<T> encode(ELEMENT input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        DEPENDENCY dependency = this.dependencyGetter.apply(input);
        RecordBuilder newPrefix = prefix.add(this.fieldName, this.elementCodecGetter.apply(dependency).encodeStart(ops, input));
        return this.dependencyMapCodec.encode(dependency, ops, newPrefix);
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.concat(Stream.of(ops.createString(this.fieldName)), this.dependencyMapCodec.keys(ops));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DependentMapCodec that = (DependentMapCodec)((Object)o);
        return Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.elementCodecGetter, that.elementCodecGetter) && Objects.equals(this.dependencyMapCodec, that.dependencyMapCodec) && Objects.equals(this.dependencyGetter, that.dependencyGetter);
    }

    public int hashCode() {
        return Objects.hash(this.fieldName, this.elementCodecGetter, this.dependencyMapCodec, this.dependencyGetter);
    }

    public String toString() {
        return "mekanism:DependentMapCodec[" + this.fieldName + ": " + this.dependencyMapCodec.keys((DynamicOps)JsonOps.INSTANCE).map(JsonElement::getAsString).distinct().collect(Collectors.joining(",")) + "]";
    }

    public <T> DataResult<ELEMENT> decode(DynamicOps<T> ops, MapLike<T> input) {
        Object value = input.get(this.fieldName);
        if (value == null) {
            return DataResult.error(() -> "No key " + this.fieldName + " in " + String.valueOf(input));
        }
        return this.dependencyMapCodec.decode(ops, input).map(this.elementCodecGetter).flatMap(elementEncoder -> elementEncoder.parse(ops, value));
    }
}

